# Способы адресации файлов

В качестве параметров методов File-блока и метода attachStylesheet Lua- и Mist-блоков, в качестве пути к файлу перблочного преобразования, в XSL-файлах, а также в других случаях бывает необходимо указать относительный путь. Для работы с относительными путями в XScript реализовано несколько схем:

- _file://_ или без указания схемы - при данном способе адресации относительный путь добавляется к пути к текущей директории.
    
    **Пример**:
    
    ```
    <mist method="attachStylesheet">
    <param type="String">/subdir/1.xsl</param>
    </mist>
    ```
    
    Предположим, данный блок описан в файле, расположенном в директории `/usr/local/www5/project/current-dir`. Тогда в качестве основного XSL-преобразования будет использоваться
    
    ```
    /usr/local/www5/project/current-dir/subdir/1.xsl
    ```
    
- _docroot://_ - при использовании этой схемы указанный относительный путь добавляется к корневой директории прокета.
    
    **Пример**:
    
    ```
    <mist method="attachStylesheet">
    <param type="String">docroot://subdir/1.xsl</param>
    </mist>
    ```
    
    Предположим, корневой директорией проекта является `rootdir`. Тогда в качестве основного XSL-преобразования будет использоваться
    
    ```
    rootdir/subdir/1.xsl
    ```
    
- _dps://_ - при использовании этой схемы указанный относительный путь добавляется к корневой директории DPS.
    
    **Пример**:
    
    ```
    <file method="load">
    <param type="String">dps://subdir/1.xml</param>
    </file>
    ```
    
    Предположим, корневой директорией DPS является `dpsroot`. Тогда в файл, из которого вызывается блок, будет вставлен XML-документ, расположенный по адресу
    
    ```
    dpsroot/subdir/1.xml
    ```
    
- _xmlbase://_ - при использовании этой схемы указанный относительный путь добавляется к пути к файлу, в котором он был указан.
    
    **Пример**:
    
    ```
    <file method="load">
    <param type="String">xmlbase://subdir/1.xml</param>
    </file>
    ```
    
    Предположим, данный блок вызывается из файла, расположенного по адресу `/usr/local/www5/project/dirA/dirB/2.xml`. Тогда в файл, из которого вызывается блок, будет вставлен XML-документ, расположенный по адресу
    
    ```
    /usr/local/www5/project/dirA/dirB/subdir/1.xml
    ```
    
    {% note info %}
    
    Настоятельно рекомендуется использование данной схемы для указания относительных путей, так как в случае двойной и более глубокой вложенности включаемых файлов путь может быть построен некорректно.
    
    Например, в файле `/usr/local/www5/project/dirA/A.xml` с помощью `xi:include` включается файл `B.xml`, расположенный в директории `/usr/local/www5/project/dirA/dirB/`.
    
    ```
    <xi:include href="dirB/B.xml">
    ```
    
    А в файле `B.xml` с помощью метода File-блока `load` без указания схемы _xmlbase://_ включается файл `C.xml`, расположенный в директории `/usr/local/www5/project/A/B/С/`.
    
    ```
    <file method="load">
    <param type="String">C/C.xml</param>
    </file>
    ```
    
    Тогда в результате обработки XML-файлов произойдет попытка найти файл `C.xml` по адресу `/usr/local/www5/project/A/C/C.xml`, а не `/usr/local/www5/project/A/B/С/C.xml`, где он на самом деле находится.
    
    {% endnote %}

### Узнайте больше {#learn-more}
* [File-блок](../concepts/block-file-ov.md)
* [Перблочное XSL-преобразование](../concepts/per-block-transformation-ov.md)