# JSON→XML

Загрузка JSON-данных с последующей автоматической конвертацией в XML может осуществляться двумя способами:

1. Из файла с помощью метода [loadJson](block-file-methods.md#loadJson) File-блока.
1. По HTTP-протоколу с помощью [методов HTTP-блока](block-http-methods.md). Возвращаемые по HTTP данные интерпретируются как JSON, если в заголовке Content-Type ответа формат возвращаемых данных описан как `text/json` или `application/json`.

Преобразование JSON→XML производится в соответствии со следующими правилами.

1. Преобразованная в XML JSON-структура размещается внутри элемента `json` (`<json>...</json>`).
1. Каждый JSON-объект преобразуется в XML-элемент. Имя XML-элемента формируется следующим образом.
    - [Канонический ключ](json-to-xml.md#canonical_key) пары ключ:значение становится именем XML-элемента.
    - Неканонический ключ пары ключ:значение приводит к формированию элемента `object` с атрибутом `name`, в который записывается ключ (`<object name="ключ">...</object>`). При этом специальные для XML символы в ключе преобразуются в сущности.
    - Элементы массива преобразуются в XML-элементы `item`.
    
1. Тип JSON-объекта записывается в атрибут type соответствующего XML-элемента. Атрибут type может принимать одно из следующих значений: <q>object</q>, <q>array</q>, <q>string</q>, <q>number</q>, <q>boolean</q>, <q>null</q>.
1. Числовые значения, превышающие допустимый предел для типа double, преобразуются в предельно допустимое для данного типа число.
1. Порядок расположения XML-элементов, соответствующих JSON-объекта одного уровня, не определен.

**Канонический ключ** {#canonical_key}

Ключ удовлетворяет условию каноничности, если выполняются следующие условия:

- первый символ ключа принадлежит множеству 'a'..'z', 'A'..'Z', '\_';
- второй и последующие символы принадлежат множеству 'a'..'z', 'A'..'Z', '\_', '-', '.', '0'..'9'.

Другими словами ключ называется каноническим, если он удовлетворяет [правилам именования XML-элементов](http://www.w3.org/TR/xml/#NT-Name) в соответствии со спецификацией XML 1.0.

**Пример преобразования JSON→XML**

В данном примере файл js_data.json считывается из файла и преобразуется в XML с помощью метода loadJson File-блока:

```
<page>
  <file method="loadJson">
    <param type="String">js_data.json</param>
  </file>
</page>
```

#|
|| js_data.json | Результат ||
||
``` 
 {
  "a1": "text entry",
  "a2": 123,
  "a3": 45.67,
  "a4": "true",
  "a5": true,
  "a6": 1,
  "a7": [
          1,
          "2",
          false,
          null,
        ],
  "a8": {
          "b1":"yandex",
          "b2":".ru",
        },
  "a&b": "key & value escaping <br />",
  "1a": "not canonical key",
  "a:b": "ill-favored key",
  "huge_num": 9876543210,
  "huge_num_as_string": "9876543210",
 } 
 ```
  | 
  ``` <page>
   <json type="object">
     <object name="1a" type="string">not canonical key</object>
     <object name="a&b" type="string">key & value escaping <br /></object>
       <a1 type="string">text entry</a1>
       <a2 type="number">123</a2>
       <a3 type="number">45.67</a3>
       <a4 type="string">true</a4>
       <a5 type="boolean">true</a5>
       <a6 type="number">1</a6>
       <a7 type="array">
         <item type="number">1</item>
         <item type="string">2</item>
         <item type="boolean">false</item>
         <item type="null"/>
       </a7>
       <a8 type="object">
         <b1 type="string">yandex</b1>
         <b2 type="string">.ru</b2>
       </a8>
     <object name="a:b" type="string">ill-favored key</object>
     <huge_num type="number">2147483647</huge_num>
     <huge_num_as_string type="string">9876543210</huge_num_as_string>
   </json>
 </page> 
 ```

||
|#

### Узнайте больше {#learn-more}
* [File-блок](../concepts/block-file-ov.md)
* [HTTP-блок](../concepts/block-http-ov.md)
