# XSL-функции

В XScript XSL-функции содержатся в двух модулях: 
- - <q>ядро</q> XScript-а, его open-source-часть;
- - модуль с технологиями Яндекса, содержащий реализацию функционала, для сборки которого необходимы различные дополнительные модули, в том числе написанные вне Яндекса.

Описание функций содержит указания на то, к какому модулю они относятся. Кроме того, функции сгруппированы в соответствии с пространствами имен, в которых они реализованы.

{% note info %}

У некоторых имен функций, содержащих в символ <q>-</q> (например <q>http-redirect</q>), есть синонимы, в которых <q>-</q> заменен на <q>\_</q> (<q>http\_redirect</q>). Настоятельно не рекомендуется использовать синонимы с <q>\_</q>. Ниже синонимы даны в скобках рядом с именами функций как справочная информация.

{% endnote %}

{% note info %}

Яндекс-сборка библиотеки libxslt также содержит [дополнительные функции](https://doc.yandex-team.ru/libxslt-patch/concepts/functions.html) `format-date` и `from-unixtime`.

{% endnote %}

#### Список XSLT-функций пространства имен http://www.yandex.ru/xscript

#|
|| [check-secret-key](xslt-functions.md#check-secret-key) | [if](xslt-functions.md#if) | [sanitize](xslt-functions.md#sanitize) ||
|| [crc32](xslt-functions.md#crc32) | [js-quote](xslt-functions.md#js-quote) | [set-http-status](xslt-functions.md#set-http-status)  ||
|| [domain](xslt-functions.md#domain) | [js-stringify](xslt-functions.md#js-stringify) | [set-state-string](xslt-functions.md#set_state_string) ||
|| [esc](xslt-functions.md#esc) | [json-quote](xslt-functions.md#json-quote) | [tolower](xslt-functions.md#tolower) ||
|| [gen-resizer-url](xslt-functions.md#gen-resizer-url) | [json-stringify](xslt-functions.md#json-stringify) | [toupper](xslt-functions.md#toupper) ||
|| [gen-resizer-url-crop](xslt-functions.md#gen-resizer-url-crop) | [libxml-version](xslt-functions.md#libxml-version) | [tzname2abbr](xslt-functions.md#tzname2abbr) ||
|| [get-cookie](xslt-functions.md#get-cookie) | [libexslt-version](xslt-functions.md#libexslt-version) | [tzname2dst](xslt-functions.md#tzname2dst) ||
|| [get-easy-secret-key](xslt-functions.md#get-easy-secret-key) | [libxslt-version](xslt-functions.md#libxslt-version) | [tzname2offset](xslt-functions.md#tzname2offset) ||
|| [get-header](xslt-functions.md#get-header) | [log-error](xslt-functions.md#log-error) | [urldecode](xslt-functions.md#urldecode) ||
|| [get-local-arg](xslt-functions.md#get-local-arg) | [log-info](xslt-functions.md#log-info) | [urlencode](xslt-functions.md#urlencode) ||
|| [get-protocol-arg](xslt-functions.md#get-protocol-arg) | [log-warn](xslt-functions.md#log-warn) | [wbr](xslt-functions.md#wbr) ||
|| [get-query-arg](xslt-functions.md#get-query-arg) | [md5](xslt-functions.md#md5) | [xml2text](xslt-functions.md#xml2text) ||
|| [get-secret-key](xslt-functions.md#get-secret-key) | [mist](xslt-functions.md#mist) | [xmlescape](xslt-functions.md#xmlescape) ||
|| [get-state-arg](xslt-functions.md#get-state-arg) | [nl2br](xslt-functions.md#nl2br) | [xmlparse](xslt-functions.md#xmlparse) ||
|| [get-vhost-arg](xslt-functions.md#get-vhost-arg) | [punycode-domain-decode](xslt-functions.md#punycode-domain-decode) | [yandex-redirect](xslt-functions.md#yandex-redirect) ||
|| [http-header-out](xslt-functions.md#http-header-out) | [punycode-domain-encode](xslt-functions.md#punycode-domain-encode) |  ||
|| [http-redirect](xslt-functions.md#http-redirect) | [remained-depth](xslt-functions.md#remained-depth) | ||
|#

#### Список XSLT-функций пространства имен http://www.yandex.ru/dps

- [list-container](xslt-functions.md#list-container).

#### Список XSLT-функций пространства имен http://exslt.org/regular-expressions

- [match](xslt-functions.md#match);
- [replace](xslt-functions.md#replace);
- [test](xslt-functions.md#test).


## Пространство имен http://www.yandex.ru/xscript (libxsсript) {#yandex-xs}

### Ядро XScript (libxscript) {#libxscript}

#### `esc` {#esc}

Экранирует встречающиеся в строке символы: `\/'-"`. Преобразует переводы строк ("`\r\n`", "`\r`", "``\n``") в строку "``\n``".

Например, строка вида

```
blah 'blah'
blah
```

после применения функции будет иметь вид

```
blah \'blah\'\nblah
```


**Входные параметры**: строка, к которой необходимо применить экранирование.

#### `crc32` {#crc32}

Вычисляет контрольную сумму от данных, переданных в качестве параметра. Эта функция работает быстрее, чем [md5](xslt-functions.md#md5).


**Входные параметры**: данные, для которых необходимо вычислить контрольную сумму.

#### `domain` {#domain}

Выделяет домен указанного уровня из названия хоста или URL-а. 
**Входные параметры**:
- URL или имя хоста;
- (опциональный параметр) уровень домена, который нужно выделить.

Результатом выполнения кода

```
<xsl:value-of select="x:domain('http://www.yandex.ru/', 2)"/>,
<xsl:value-of select="x:domain('yandex.ru/', 1)"/>,
<xsl:value-of select="x:domain('http://www.yandex.ru:80/page', 3)"/>,
<xsl:value-of select="x:domain('http://www.subdomain.yandex.ru', 4)"/>
```

будет строка

```
yandex.ru, ru, www.yandex.ru, www.subdomain.yandex.ru
```

Функция является аналогом метода [set_state_domain](block-mist-methods.md#set_state_domain) mist-блока и метода [domain](block-lua-other-methods.md#other_domain) lua-блока.

#### `get-cookie` {#get-cookie}

Возвращает значение куки с указанным именем.


**Входные параметры**:
- имя интересующей куки;
- значение, которое возвращается, если кука с указанным именем не найдена.

#### `get-header` {#get-header}

Возвращает значение HTTP-заголовка с указанным именем.


**Входные параметры**:
- имя интересующего HTTP-заголовка;
- значение, которое возвращается, если заголовок с указанным именем не найден.

#### `get-protocol-arg` {#get-protocol-arg}

Возвращает значение переменной ProtocolArg.


**Входные параметры**: имя интересующей переменной.

#### `get-query-arg` {#get-query-arg}

Возвращает значение переданного в URL параметра. При отсутствии параметра с заданным именем возвращается пустая строка.


**Входные параметры**:
- имя интересующего параметра;
- значение, которое возвращается, если параметр с указанным именем не найден.

#### `get-state-arg (get_state_arg)` {#get-state-arg}

Получает из контейнера State значение переменной, имя которой передано во входном параметре. При отсутствии переменной с заданным именем возвращается пустая строка.

**Входные параметры**: 
- имя переменной, для которой необходимо получить значение из State;
- значение, которое возвращается, если переменной с указанным именем не найдено.

#### `get-vhost-arg` (`get_vhost_arg`) {#get-vhost-arg}

Позволяет получить значение параметра [конфигурационного файла](config.md) или переменной окружения, имя которой начинается с "XSCRIPT_".


**Входные параметры**:

- путь к интересующей настройке, исключая корневой элемент \<xscript\>, или имя переменной окружения. Например, для настройки
    
    ```
    <xscript>
    ...
    <auth>
    <root-domain>ya.ru</root-domain>
    </auth>
    ...
    </xscript
    ```
    
    путь будет выглядеть следующим образом: `auth/root-domain`;
    
- (опциональный параметр) значение по умолчанию, которое будет использоваться, если заданный параметр конфигурационного файла или переменная окружения не найдены.

#### `http-header-out (http_header_out)` {#http-header-out}

Добавляет в заголовки HTTP-ответа новый параметр и его значение.

**Входные параметры**: 
- имя параметра, который необходимо добавить в HTTP-заголовки;
- значение для этого параметра.

#### `http-redirect (http_redirect)` {#http-redirect}

Устанавливает статус HTTP-запроса 302 и HTTP-заголовки (HTTP Headers) для редиректа на заданную страницу.

**Входные параметры**: строка, содержащая URL страницы, на которую должен быть выполнен редирект.

#### `if` {#if}

Проверяет условие, и в случае его истинности выполняет указанное выражение. В противном случае выполняется альтернативное выражение (опционально).


**Входные параметры**:

- условие;
- выражение, которое будет выполнено в случае истинности условия;
- (опциональный параметр) выражение, которое будет выполнено, если условие ложно.

**Пример**:

```
<xsl:variable name="node1">
   <html>
      <head\>\</head>
      <body>
         <br/>
         <wbr/>
      </body>
    </html>
</xsl:variable>

<xsl:variable name="node2">
   <AAA>BBB</AAA>
</xsl:variable>

<xsl:variable name="nodes1" select="exslt:node-set($node1)"/>
<xsl:variable name="nodes2" select="exslt:node-set($node2)"/>

<xsl:value-of select="x:if(string-length($nodes1), $nodes1, $nodes2)"/>
```

#### `json-quote` {#json-quote}

Выполняет экранирование символов строки в соответствии с синтаксисом JSON. Перед символами 
```
" 
\ 
/ 
\b 
\f 
\n 
\r 
\t 
\u34f3 (обозначения Unicode-символов)
```
добавляется обратный слеш ("\"). При этом вся строка заключается в двойные кавычки.Более подробное описание ищите на [http://json.org/](http://json.org/).


**Входные параметры**: строка, к которой необходимо применить экранирование.

#### `json-stringify` {#json-stringify}

Преобразует XML-элемент в формат JSON (см. раздел [XML→JSON](xml-to-json.md)). Для экранирования символов используется функция [json-quote](xslt-functions.md#json-quote).

При обработке элементов `json` (`<json> ... </json>`) содержимое выводится как есть, валидация с помощью json-парсера производится только при подключенном [xscript-development](../concepts/modules.md).


**Входные параметры**: множество узлов (nodeset), содержащее указатель на XML-элемент или XML-документ.

#### `js-quote` {#js-quote}
Выполняет те же действия, что и [esc](xslt-functions.md#esc), за исключением экранирования двойных кавычек ("), и заключает результат в апострофы (').

**Входные параметры**: строка, к которой необходимо применить экранирование.

#### `js-stringify` {#js-stringify}

Преобразует XML-элемент в формат JSON (см. раздел [XML→JSON](xml-to-json.md)). Для экранировки символов используется функция [js-quote](xslt-functions.md#js-quote).

При обработке элементов `json` (`<json> ... </json>`) содержимое валидируется json-парсером. На выходе ключи объекта пересортируются, [ws-символы](http://tools.ietf.org/html/rfc4627#section-2) убираются. Эта операция ресурсозатратная.


**Входные параметры**: множество узлов (nodeset), содержащее указатель на XML-элемент или XML-документ.

#### `libexslt-version` {#libexslt-version}

Возвращает номер установленной версии библиотеки libexslt.


**Входные параметры**: отсутствуют.

#### `libxml-version` {#libxml-version}

Возвращает номер установленной версии библиотеки libxml2.


**Входные параметры**: отсутствуют.

#### `libxslt-version` {#libxslt-version}

Возвращает номер установленной версии библиотеки libxslt.


**Входные параметры**: отсутствуют.

#### `log-error` {#log-error}

Записывает в лог XScript сообщение с уровнем логирования `ERROR`. Сообщение формируется путем склеивания строк, переданных во входных параметрах.


**Входные параметры**: набор строк (не менее одной строки) с текстом сообщения, которое необходимо записать в лог.

#### `log-info` {#log-info}

Записывает в лог XScript сообщение с уровнем логирования `INFO`. Сообщение формируется путем склеивания строк, переданных во входных параметрах. Если уровень логирования XScript, указанный в [файле настроек](config.md), меньше, чем `INFO`, запись в лог не произойдет.


**Входные параметры**: набор строк (не менее одной строки) с текстом сообщения, которое необходимо записать в лог.

#### `log-warn` {#log-warn}

Записывает в лог XScript сообщение с уровнем логирования `WARN`. Сообщение формируется путем склеивания строк, переданных во входных параметрах. Если уровень логирования XScript, указанный в [файле настроек](config.md), меньше, чем `WARN`, запись в лог не произойдет.


**Входные параметры**: набор строк (не менее одной строки) с текстом сообщения, которое необходимо записать в лог.

#### `md5` {#md5}

Вычисляет хэш MD5 для входной строки.

**Входные параметры**: строка, для которой необходимо вычислить MD5.

#### `nl2br` {#nl2br}

Производит замену переносов строк тегом `<br/>`. Возвращает nodeset, элементами которого являются текстовые строки и `<br/>`.
Например, строка
```
"blah blah
blah"
```

будет преобразована к виду
```
"blah blah<br />blah"
```


**Входные параметры**: строка, в которой необходимо заменить переносы на `<br/>`.

#### `punycode-domain-decode` {#punycode-domain-decode}

Производит [punycode-декодирование](http://www.wwhois.ru/chto-takoe-punycode.md) доменного имени. При таком декодировании символы преобразуются из кодировки LDH в символы национальных алфавитов. Используется для [IDN-доменов](http://ru.wikipedia.org/wiki/IDN).

**Входные параметры**:

- доменное имя;
- (опциональный параметр) результирующая кодировка. По умолчанию предполагается, что результирующая кодировка UTF-8.

Например, код

```
<xsl:value-of select="x:punycode-domain-decode('www.xn--d1acpjx3f.xn--p1ai')"/>
```

возвратит строку

```
www.яндекс.рф
```

Функция является аналогом метода [punycodeDomainDecode](block-lua-other-methods.md#punycodeDomainDecode) lua-блока.

#### `punycode-domain-encode` {#punycode-domain-encode}

Производит [punycode-кодирование](http://www.wwhois.ru/chto-takoe-punycode.md) доменного имени. При таком кодировании символы национальных алфавитов преобразуются в кодировку LDH. Используется для [IDN-доменов](http://ru.wikipedia.org/wiki/IDN).

**Входные параметры**:

- доменное имя;
- (опциональный параметр) исходная кодировка. По умолчанию предполагается, что исходная кодировка UTF-8.

Результатом выполнения кода

```
<xsl:value-of select="x:punycode-domain-encode('яндекс.рф')"/>,
<xsl:value-of select="x:punycode-domain-encode('www.ЯНДЕКС.ru')"/>
```

будет строка

```
xn--d1acpjx3f.xn--p1ai, www.xn--g0acpjx3f.ru
```

Функция является аналогом метода [punycodeDomainEncode](block-lua-other-methods.md#punycodeDomainEncode) lua-блока.

#### `remained-depth` {#remained-depth}

Возвращает допустимое число вложений шаблонов, которое рассчитывается как разница между максимально допустимой вложенностью и текущей вложенностью.
Максимальная вложенность задается в [файле настроек](config.md) с помощью параметра `xscript|xslt|max-depth`. Значение параметра по умолчанию: 300.


**Входные параметры**: отсутствуют.

#### `set-http-status (set_http_status)` {#set-http-status}

Устанавливает в заголовке HTTP-запроса статус, переданный во входной строке. Перед установкой входная строка преобразуется в число.

**Входные параметры**: строка, содержащая нужный статус.

#### `set-state-string` {#set_state_string}

Создает в контейнере State переменную строкового типа с заданными именем и значением. Аналог метода Mist-блока [set_state_string](block-mist-methods.md#set_state_string).


**Входные параметры**:

- имя создаваемой переменной;
- значение создаваемой переменной.

#### `urldecode` {#urldecode}

Декодирует URL-encoded-строку (может содержать URL, параметры и т.п.), а затем переводит из заданной кодировки в UTF-8.

**Входные параметры**:
- кодировка декодируемой строки, опциональный параметр (если он не указан, перевод кодировки не выполняется);
- строка, к которой необходимо применить urldecode.

#### `urlencode` {#urlencode}

Переводит строку (может содержать URL, параметры и т.п.) из UTF-8 в заданную кодировку, а затем urlencode-ит её. Urlencode подразумевает, что каждый символ строки заменяется на знак процента (%), за которыми следует коды символа в шестнадцатеричном формате.

**Входные параметры**: 
- кодировка, в которую необходимо перевести строку, опциональный параметр (если он не указан, перевод кодировки не выполняется);
- строка, к которой необходимо применить urlencode.

#### `wbr` {#wbr}

Логически разбивает строку на слова, разделенные символом пробела. Выделенные слова разбиваются на подстроки, длина которых равна значению второго входного параметра, и между получившимися подстроками вставляется тег `<wbr/>`. Возвращает результат в виде nodeset.
Например, вызов функции
```
<xsl:copy-of select="x:wbr('тутидетдлиннаястрокаблабла и не очень длинная строка иwre#$%DFGHssdfgfhgsssлоывлорывсякая ерунда', 10)"/>
```

даст следующий результат:
```
тутидетдли
<wbr/>
ннаястрока
<wbr/>
блабла и не очень длинная строка иwre#$%DFG
<wbr/>
Hssdfgfhgs
<wbr/>
ssлоывлоры
<wbr/>
всякая ерунда
```


**Входные параметры**: 
- Строка, к которой применяется функция;
- Количество символов в подстроках, на которые разбиваются слова.

#### `xmlescape` {#xmlescape}

Возвращает результат XML-эскейпинга строки. XML-эскейпинг подразумевает следующую замену символов в строке:

```
> на &gt;
< на &lt;
& на &amp;
' на &#39;
" на &quot;
```


**Входные параметры**: строка, к которой необходимо применить xml-escaping.

#### `xmlparse` {#xmlparse}

Возвращает результат парсинга XML в виде nodeset.


**Входные параметры**: строка (XML).

#### `yandex-redirect` {#yandex-redirect}

Формирует неподписанные либо подписанные, либо шифрованные ссылки для сервиса [Клик-демон](https://wiki.yandex-team.ru/Clickdaemon), который выполняет редирект по указанной ссылке.Например, неподписанная ссылка для редиректа на адрес `http://market.yandex.ru/model.xml?hid=91148&modelid=1020588` будет выглядеть следующим образом:

```
http://clck2.yandex.ru/redir/dtype=stred/pid=47/cid=1564/*http://market.yandex.ru/model.xml?hid=91148&modelid=1020588
```


**Входные параметры**:
- строка внутренних параметров сервиса Клик-демон, которые указываются после "/redir/" и до "\*" включительно. В приведенном выше примере это `"dtype=stred/pid=47/cid=1564/*"`;
- URL, на который производится редирект. В приведенном примере это `http://market.yandex.ru/model.xml?hid=91148&modelid=1020588`.
- вид генерируемой ссылки: “unsigned” (неподписанная), “signed” (подписанная ключом) и “crypted” (подписанная ключом и зашифрованная). Список ключей для подписи ссылок должен быть указан в [файле настроек XScript](config.md).


### Пакет xscript-geo, модуль xscript-geo {#xscriptgeo}

#### `tzname2abbr` {#tzname2abbr}

Возвращает текущую аббревиатуру временной зоны.


**Входные параметры**: идентификатор временной зоны в UNIX-формате, например "Europe/Moscow".

#### `tzname2offset` {#tzname2offset}

Возвращает для указанной временной зоны её смешение относительно UTC.


**Входные параметры**: идентификатор временной зоны в UNIX-формате, например "Europe/Moscow".

#### `tzname2dst` {#tzname2dst}

Возвращает для указанной временной зоны информацию о текущем используемом времени ('dst' — летнее время, 'std' — зимнее, 'never' — время не меняется никогда).


**Входные параметры**: идентификатор временной зоны в UNIX-формате, например "Europe/Moscow".


### Пакет xscript-yandex-sanitizer, модуль xscript-yandex-sanitizer {#sanitizer}

#### `sanitize` {#sanitize}

При помощи алгоритма санитайзинга из Аркадии "очищает" html, удаляя из него опасные фрагменты кода, и возвращает nodeset, содержащий полученный в результате очистки xhtml. При очистке выполняются следующие действия:
- Удаляются скрипты (`<script>`, `<... onclick="...">`, `style="...expr(...)"`);
- Удаляет "плохие" стили (`position: absolute`, не инлайновые стили (`<style>...</style>`));
- Удаляет `class="...", id="..."`;
- Отправляет flash-контент с доменов, не входящих в список доменов, которым доверяет Яндекс, через прокси xss.yandex.net;
- Строит корректный xml (закрывает теги и т.д.).

Работает только если подключен модуль `xscript-yandex-sanitizer`, в противном случае возвращает исходный текст.


**Входные параметры**: строка, содержащая html, который необходимо "очистить".


### Пакет xscript-standard, модуль xscript-local {#xscript-local}

#### `get-local-arg` {#get-local-arg}

Получает из [LocalArgs](../concepts/block-local-ov.md#localargs) значение переменной с заданным именем.


**Входные параметры**:

- имя переменной LocalArgs, значение которой необходимо получить;
- (опциональный параметр) значение, которое возвращается в случае отсутствия переменной с указанным именем. По умолчанию - пустая строка.


### Пакет xscript-standard, модуль xscript-mist {#xscriptmist}

#### `mist` {#mist}

Позволяет вызывать любые [Mist-методы](block-mist-methods.md). Возвращает nodeset, аналогичный возвращаемому в результате вызова метода Mist-блока.


**Входные параметры**:

- имя вызываемого метода;
- параметры, которые принимает метод, перечисленные через запятую.

**Пример**:

```
x:mist('set_state_by_protocol', 'prefix')
```


### Пакет xscript-standard, модуль xscript-xslt {#xscriptxslt}

#### `tolower` {#tolower}

Переводит строку в UTF-8 в нижний регистр.

**Входные параметры**: строка в UTF-8, которую необходимо перевести в нижний регистр.

#### `toupper` {#toupper}

Переводит строку в UTF-8 в верхний регистр.

**Входные параметры**: строка в UTF-8, которую необходимо перевести в верхний регистр.


### Пакет xscript-yandex, модуль xscript-yandex {#yandex-xscript}

#### `check-secret-key`{#check-secret-key} {#check-secret-key}

Возвращает результат сравнения секретного ключа с указанным параметром запроса.
 Если они совпадают, возвращается булевское значение "1", если нет - "0".


**Входные параметры**: строка, с которой сравнивается значение секретного ключа.

#### `gen-resizer-url` {#gen-resizer-url}

Генерирует подписанные ссылки для [Ресайзера изображений](http://wiki.yandex-team.ru/resizer).


**Входные параметры**:

- адрес изображения, размер которого необходимо изменить;
- ширина, которую должно иметь изображение;
- длина, которую должно иметь изображение;
- (опциональный параметр) адрес другого изображения, которое для ускорения последующей обработки будет скачано, положено в кэш, и при его запросе будет считано из кэша. При этом размер закэшированного изображения будет изменен в соответствии с параметрами, указанными при данном вызове.

**Пример**:

```
<xsl:value-of
select="x:gen-resizer-url('http://www.sports.ru/_assets/object_63.1263207404.60524.jpg',
'120', '150')"/>
```

#### `gen-resizer-url-crop` {#gen-resizer-url-crop}

Генерирует подписанные ссылки для [Ресайзера изображений](http://wiki.yandex-team.ru/resizer), обрезая (crop) картинку до нужного размера. Обрезка картинки подразумевает, что она уменьшается пропорционально, и если при этом по вертикали или горизонтали она превышает запрошенный размер, то снизу и сверху или справа и слева отрезаются фрагменты одинакового размера.


**Входные параметры**:

- адрес изображения, которое необходимо обрезать (crop);
- ширина, которую должно иметь изображение;
- длина, которую должно иметь изображение;
- (опциональный параметр) адрес другого изображения, которое для ускорения последующей обработки будет скачано, положено в кэш, и при его запросе будет считано из кэша. При этом размер закэшированного изображения будет изменен в соответствии с параметрами, указанными при данном вызове.

**Пример**:

```
<xsl:value-of
select="x:gen-resizer-url-crop('http://www.sports.ru/_assets/object_63.1263207404.60524.jpg',
'120', '150')"/>
```

#### `get-easy-secret-key`{#get-easy-secret-key}

Возвращает сгенерированный простой секретный ключ (без использования авторизации).


**Входные параметры**: отсутствуют.

#### `get-secret-key` {#get-secret-key}

Возвращает сгенерированный секретный ключ.


**Входные параметры**: отсутствуют.

#### `xml2text` {#xml2text}

Склеивает элементы nodeset-а в одну строку. При этом "схлопываются" пустые элементы следующих типов:
 \<area\>, \<br\>, \<base\>, \<basefont\>, \<col\>, \<embed\>, \<frame\>, \<hr\>, \<img\>, \<input\>, \<isindex\>, \<link\>, \<meta\>, \<param\>, \<wbr\>, т.е. вместо `<img\>\</img>` в строке результата будет записано `<img/>`.

Например, в результате применения функции к nodeset-у

```
<html>
    <head\>\</head>
    <body>
         <br/>
         <wbr/>
         <script\>\</script>
         <div\>\</div>
         <div/>
    </body>
</html>
```

будет получена строка \<html\>\<head\>\</head\>\<body\>\<br/\>\<wbr/\>\<script\>\</script\>\<div\>\</div\>\<div/\>\</body\>\</html\>.


**Входные параметры**: nodeset.


## Пространство имен http://www.yandex.ru/dps (пакет xscript-yandex, модуль xscript-yandex) {#dps}

#### `list-container` {#list-container}
Получает содержимое файла .dps.xml в заданном каталоге проекта DPS и возвращает nodeset с содержимым этого файла.

**Входные параметры**: путь к файлу .dps.xml относительно `/var/cache/dps/stable`.

{% note info %}

DPS - написанная в Яндексе система управления контентом, позволяющая хранить и мгновенно обновлять в продакшн-среде контент страниц, имеющая собственную файловую систему с управлением версиями документов.

{% endnote %}


## Пространство имен http://exslt.org/regular-expressions (пакет xscript-standard, модуль xscript-xslt) {#regular-expressions}

Дополнительную информацию об описанных ниже функциях ищите на [http://www.exslt.org/regexp/index.html](http://www.exslt.org/regexp/index.md)

#### `match` {#match}
Разбивает строку на подстроки, удовлетворяющие заданному регулярному выражению, и возвращает результат в виде nodeset. 


**Входные параметры**: 
- Строка, из которой должны быть выделены подстроки;
- Регулярное выражение, которому должны удовлетворять выделяемые подстроки. Использует синтаксис JavaScript-а;
- Флаг 'i', 'g' или их комбинации ('gi', 'ig').
    Флаг 'i' позволяет применить регулярное выражение без учета регистра символов в строке.
    
    Флаг 'g' позволяет выполнить глобальный поиск всех вхождений подстроки, а не только первого вхождения, как будет сделано в отсутствии этого флага.

#### `replace` {#replace}
Заменяет подстроку, удовлетворяющую заданному регулярному выражению, переданной во входных параметрах подстрокой.

**Входные параметры**:
- Строка, в которой необходимо выполнить замену;
- Регулярное выражение, которому должны удовлетворять замещаемые подстроки. Использует синтаксис JavaScript-а;
- Флаг 'i', 'g' или их комбинации ('gi', 'ig').
    Флаг 'i' позволяет применить регулярное выражение без учета регистра символов в строке.
    
    Флаг 'g' позволяет выполнить глобальный поиск всех вхождений подстроки, а не только первого вхождения, как будет сделано в отсутствии этого флага.
    
- Строка, на которую должна быть заменена найденная подстрока.

#### `test` {#test}
Проверяет, что строка удовлетворяет заданному регулярному выражению, и если удовлетворяет, возвращает значение 'true'.

**Входные параметры**:
- Строка, которую необходимо проверить;
- Регулярное выражение, которому должна удовлетворять строка. Использует синтаксис JavaScript-а;
- Флаг 'i', 'g' или их комбинации ('gi', 'ig').
    Флаг 'i' позволяет применить регулярное выражение без учета регистра символов в строке.
    
    Флаг 'g' позволяет выполнить глобальный поиск всех вхождений подстроки, а не только первого вхождения, как будет сделано в отсутствии этого флага.

### Узнайте больше {#learn-more}
* [libxslt](http://xmlsoft.org/XSLT/)
* [EXSLT](http://www.exslt.org/)