# File-блок

_File-блок_ блок позволяет считывать из файла текстовые и бинарные данные.

Текстовые данные могут интерпретироваться как XML, JSON или простой текст и после считывания включаются в XScript-страницу. При загрузке XML-данных, основное XSL-преобразование на них не накладывается. JSON-данные сначала [преобразуются в XML](../appendices/json-to-xml.md), а затем включаются в страницу. При этом основное XSL-преобразование на полученный XML также не накладывается. В текстовых данных перед вставкой в страницу производится экранировка специальных XML-символов (замена их на сущности).

При обработке бинарного файла, формируется HTTP-ответ, тело которого состоит из содержимого файла.

File-блок может выполняться асинхронно (если установлен атрибут [threaded="yes"](../appendices/attrs-ov.md#threaded)), а результаты его работы могут [кэшироваться](block-results-caching.md).

Входные параметры методов File-блока могут [конкатенироваться](../appendices/block-file-methods.md).

**Пример File-блока**:

```
<file>
   <method>invoke</method>
   <param type="String">/usr/local/www/project/index.xml</param>
</file>
```

В приведенном примере в результирующий XML-документ вставляется XML-документ `/usr/local/www/project/index.xml`, при чем в загружаемом документе предварительно обрабатываются конструкции `xi:include` и XScript-блоки, если они в нем присутствуют.

### Узнайте больше {#learn-more}
* [Методы File-блока](../appendices/block-file-methods.md)
* [file](../reference/file.md)