# Geo-блок

Geo-блок предоставляет информацию о гео-административной структуре территории Земли и обеспечивает определение местонахождения пользователя в этой структуре, используя данные Геобазы, закэшированные в XScript. Это позволяет избежать обращения к CORBA-серванту Geobase.

{% note info %}

Для использования данного типа блока необходимо подключить модуль _xscript-geo_ версии 5.41-1 или выше.

{% endnote %}

**Пример Geo-блока**:

```
<geo-block>
    <method>set_state_region</method>
    <param type="String">region</param>
</geo-block>
```

В приведенном примере выполняется получение id региона посетителя по его IP-адресу.

Ряд методов Geo-блока позволяет получить XML-дерево регионов. При этом о каждом регионе может быть возвращена следующая информация:

- id - идентификатор региона;
- name - русскоязычное название региона;
- syn - синонимы для названия региона, перечисленные через запятую;
- genitive - название региона в родительном падеже;
- dative - название региона в дательном падеже;
- locative - название региона в предложном падеже;
- preposition - предлог, употребляющийся перед именем региона;
- ua_name - название региона на украинском языке;
- uaname_genitive - название региона на украинском языке в родительном падеже;
- uaname_dative - название региона на украинском языке в дательном падеже;
- uaname_locative - название региона на украинском языке в предложном падеже;
- uaname_preposition - предлог, употребляющийся перед именем региона в украинском языке;
- byname - название региона на белорусском языке;
- byname_genitive - название региона на белорусском языке в родительном падеже;
- byname_dative - название региона на белорусском языке в дательном падеже;
- byname_locative - название региона на белорусском языке в предложном падеже;
- byname_preposition - предлог, употребляющийся перед именем региона в белорусском языке;
- kz_name - название региона на казахском языке;
- kzname_genitive - название региона на казахском языке в родительном падеже;
- kzname_dative - название региона на казахском языке в дательном падеже;
- kzname_locative - название региона на казахском языке в предложном падеже;
- kzname_preposition — предлог, употребляющийся перед именем региона в казахском языке;
- ename - название региона на английском языке;
- short_ename - краткое название региона на английском языке;
- pid/parent - идентификатор родительского региона;
- main - флаг, указывающий, что регион является главным на данном уровне дерева;
- chief_region - id главного региона для текущего региона;
- pos, position - позиция в Геобазе, показывающая популярность региона;
- type - тип региона. Значения поля смотрите в [описании libgeobase](https://doc.yandex-team.ru/lib/libgeobase5/concepts/region-types.html);
- timezone - флаг, указывающий, определен ли часовой пояс для данного региона (0 - не определен, 1 - определен);
- phone_code - телефонный код региона;
- zip - почтовый код региона;
- lat - широта, на которой находится регион;
- lon - долгота, на которой находится регион;
- spn_lat - спан для широты;
- spn_lon - спан для долготы;
- zoom - зум;
- tz_name - имя часового пояса региона;
- tz_abbr - принятая аббревиатура часового пояса (например, "MSK" - Москва);
- tz_offset - текущее смещение относительно UTC в секундах;
- tz_dst - флаг, указывающий летнее или зимнее время в данный момент в регионе. Возможные значения: "std" - зимнее время,"dst" - летнее время;
- bs -флаг, указывающий, есть ли для региона Баннерокрутилка (0 - нет, 1 - есть);
- yaca - флаг, указывающий, есть ли для региона Каталог (0 - нет, 1 - есть);
- weather - флаг, указывающий, есть ли для региона Погода (0 - нет, 1 - есть);
- afisha - флаг, указывающий, есть ли для региона Афиша (0 - нет, 1 - есть);
- maps - флаг, указывающий, есть ли для региона Карты (0 - нет, 1 - есть);
- tv - флаг, указывающий, есть ли для региона Телепрограмма (0 - нет, 1 - есть).

Каждый раз при формировании контекста запроса происходит обращение к модулю xscript-geo, и в HTTP-заголовки объекта [Request](request-ov.md) добавляется заголовок _X-Region_, содержащий id региона для IP-адреса, с которого пришел запрос.

Если в ходе получения иформации о регионе пользователя при проверке куки _yandex_gid_ или заголовка _X-Forwarded-For_ определяется регион "Яндекс", выполняется дополнительная проверка региона по IP-адресу.

### Узнайте больше {#learn-more}
* [Методы Geo-блока](../appendices/block-geo-methods.md)
* [geo-block](../reference/geo.md)
* [Подготовка данных при помощи пакета geobase-builder](https://wiki.yandex-team.ru/LeonidMovsesjan/XGeo/GeoBuilder)
* [Настройка xscript-geo](../appendices/config-params.md#xscript-geo)
* [Использование xscript-geo](https://wiki.yandex-team.ru/LeonidMovsesjan/XGeo/XGeoUsage)