# Понятие XScript-блока и его типы 

Базовым элементом XML-файла, написанного на XScript, является _блок_ - фрагмент XML-нотации, содержащий описание локального или удаленного вызова метода.

В результате [обработки блока](block-handling-ov.md) исходное описание блока заменяется XML-фрагментом, содержащем данные, возвращенные вызванным методом.

Обычно методам, вызываемым в XScript-блоках, передаётся один или несколько [параметров](parameters-ov.md).

Из блока параметры могут передаваться в [перблочное XSL-преобразование](per-block-transformation-ov.md) с помощью тега [xslt-param](../reference/xslt-param.md).

Блоки могут иметь [атрибуты](../appendices/attrs-ov.md), значения которых влияют на процесс и результат обработки блока.

Блоки не могут быть вложенными.

Для получения [мета-информации](meta.md) о вызове блока используется тег [\<meta\>](../reference/meta-tag.md).

Существует несколько типов XScript-блоков:

- [Auth-блок](block-auth-ov.md) - авторизация пользователя.
- [Banner-блок](block-banner-ov.md) - генерация параметров для работы с Баннерной системой.
- [CORBA-блок](block-corba-ov.md) - удаленные вызовы CORBA-сервантов.
- [Custom-morda-блок](block-custom-morda-ov.md) - обработка настроек пользователя.
- [File-блок](block-file-ov.md) - слияние XML-документов.
- [Geo-блок](block-geo-ov.md) - предоставление информации о гео-административной структуре территории Земли и обеспечение определения местонахождения пользователя в этой структуре.
- [HTTP-блок](block-http-ov.md) - удаленные вызовы по протоколу HTTP.
- [Local-блок](block-local-ov.md) - выполнение дополнительных скриптов, описанных в теле XML-файла.
- [Lua-блок](block-lua-ov.md) - выполнение скриптов на языке Lua.
- [Mist-блок](block-mist-ov.md) - работа с контейнером State.
- [Mobile-блок](block-mobile-ov.md) - получение информации о мобильном телефоне.
- [Tinyurl-блок](block-tinyurl-ov.md) - генерация коротких URL-ов.
- [While-блок](block-while-ov.md) - цикл, выполняющийся до тех пор, пока истинно условие [\<guard\>](../reference/guard.md) или [\<guard-not\>](../reference/guard-not.md).

**Пример блока**:

```
<mist>
    <method>set_state_by_request</method>
    <param type="String">test</param>
</mist>
```

В результате обработки этого блока в XML-файл будет помещен следующий фрагмент:

```
<state prefix="test" type="Request"/>
```

### Узнайте больше {#learn-more}
* [Обработка XScript-блока](./block-handling-ov.md)
* [Кэширование результата работы XScript-блока](./block-results-caching.md)