# Кэширование результата работы XScript-блока

Для кэширования результатов работы блока в XScript используются атрибут [tag](../appendices/attrs-ov.md#tag) или параметр [Tag](tag-ov.md). Данные помещаются в так называемый _tagged кэш_.

Одновременное использование атрибута tag и параметра Tag запрещено.

В кэш помещаются результаты работы блока с учетом наложения перблочного XSL-преобразования (если таковое присутствует).

В ключ кэша входят:
- название блока;
- имя вызываемого метода;
- значения параметров блока;
- имя перблочного XSL-преобразования;
- значения XSLT-параметров блока ([\<xslt-param\>](../reference/xslt-param.md)), при чем XSLT-параметры входят в расчет ключа даже в случае отсутствия перблочного наложения, что позволяет управлять кэшированием со стороны верстки.

Как tag, так и Tag позволяют кэшировать результаты работы [CORBA-](block-corba-ov.md), [HTTP-](block-http-ov.md) и [File-блоков](block-file-ov.md). Кэшированием всегда управляет XScript, за исключением случая использования Tag для кэширования результатов работы CORBA-блока, когда кэшированием управляет сервант. При этом сигнатура вызываемого метода обязательно должна содержать параметр Tag.

Tag и tag могут иметь различные варианты значений: целое число, "yes" или пустое значение. 
- Если значением Tag или tag является целое число, оно определяет время (в секундах), на которое будет закэшированы результаты работы блока.
- Значение "yes" атрибута tag может быть указано только в File-блоке и HTTP-блоке. В этом случае результат работы File-блока будет получаться из кэша до тех пор, пока не изменится файл, запрошенный из File-блока. Кэширование результата работы HTTP-блока зависит от наличия заголовков _Expires_ и _Last-Modified_ в HTTP-ответе:
    - При отсутствии обоих заголовков кэширование не производитcя;
    - При наличии только заголовка Last-Modified результат будет закэширован, но при следующих вызовах блока будет осуществляться попытка забрать контент с сервера, а закэшированная копия будут использоваться только в случае ответа c кодом 304;
    - При наличии заголовка Expires кэширование производится и результат работы блока будет валиден до наступления времени, указанного в Expires.
    
- В случае пустого значения параметра Tag в CORBA-блоке временем кэширования управляет CORBA-сервант. В случае пустого значения Tag в других блоках, правила кэширования такие же, как для `tag="yes"`.

**Пример использования атрибута tag**:

```
<block tag="60">
    <name>Yandex/Project/Example.id</name>
    <method>getSomeInfo</method>
    <param type="Request"/>
    <param type="StateArg">surname</param>
</block>
```

**Пример использования параметра Tag**:

```
<block>
    <name>Yandex/Blogs/Blogger.id</name>
    <method>GetAvatarsProxies</method>
    <param type="Tag"/>
</block>
```


## Частичная отмена кэширования результатов работы блока {#dont-cache}

Существует возможность отменить кэширование результатов работы блока для пользователей с определенным авторизационным статусом. Для этого в теге блока должен быть определен атрибут [no-cache](../appendices/attrs-ov.md#no-cache), принимающий значения "uid" (запрет кэширования для авторизованных пользователей) и "lite" (запрет кэширования для [Lite-пользователей](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About)), а также оба эти значения, разделенные пробелом ("uid lite" - запрет кэширования и для авторизованных, и для Lite-пользователей). Для неавторизованных пользователей кэширование будет разрешено вне зависимости от значения данного параметра.

Пример запрета на кэширование результата работы блока для авторизованных пользователей:

```
<http no-cache="uid" tag="100">
     <method>getHttp</method>
     <param type="String">http://some.yandex.ru/lite_user.xml?uid=</param>
     <param type="LiteUID" as="String"/> 
</http>
```

### Узнайте больше {#learn-more}
* [Кэширование XML-страницы](../concepts/caching-ov.md)
* [Обработка XScript-блока](../concepts/block-handling-ov.md)
* [Как закэшировать результат работы блока с учетом параметра](../tasks/how-to-cache-with-param.md)