# Кэширование XML-страницы

## Кэширование исходного XML- и XSL-файлов {#xml-file}

XScript автоматически кэширует результаты парсинга и компиляции исходного XML-файла при первом обращении к нему, а также XSL-файлов основного и перблочного преобразований, если в [файле настроек](../appendices/config.md) подключен модуль кэширования `xscript-xmlcache.so`.


## Кэширование выходной страницы на уровне XScript {#result-page-cache}

Кэширование результатов обработки запроса на уровне XScript выполняется только в том случае, если:
- в XML-файле подключена одна из определенных в конфигурационном файле [стратегий кэширования](page-cache-strategies.md). Для этого в теге [\<xscript\>](../reference/xscript.md) должен быть указан атрибут [cache-strategy](../reference/xscript.md#cache-strategy);
- для страницы явно задан запрет на авторизацию (в теге [\<xscript\>](../reference/xscript.md) указан атрибут `no-auth="yes"`) или отсутствует кука _Session_id_;
- страница была запрошена методом GET;
- статус HTTP-ответа - 200;
- при обработке страницы не возникло ошибок вызова блоков;
- при обработке страницы не было переопределено основное XSL-наложение (с помощью метода Mist-блока [attach_stylesheet](../appendices/block-mist-methods.md#attach_stylesheet));
- при обработке страницы не были установлены куки;
- возвращаемый контент не является бинарным.

В расчете ключа кэша участвуют следующие параметры:
- исходный URL запроса без параметров запроса (`query`);
- время модификации XML-файла;
- времена модификации файлов, подключенных через [xi:include](../reference/xi-include.md);
- время модификации файла основного XSL-преобразования;
- времена модификации файлов перблочных XSL-преобразований;
- определенные в [стратегии кэширования](page-cache-strategies.md) куки, регионы и параметры запроса.

В кэш, наряду с выходной страницей, помещаются заголовки HTTP-ответа.


## Кэширование выходной страницы на уровне клиента {#client-caching}

Конечный результат работы XScript, то есть в большинстве случаев — веб-страница, выданная по протоколу HTTP, может и должна кэшироваться на уровне клиента и промежуточных серверов в соответствии с RFC 2616.

Управлять таким кэшированием можно с помощью заголовков HTTP-ответа.

Добавлять заголовки Expires, no-cache, max-age и прочие можно тремя способами:

- с помощью тега [\<add-headers\>](../reference/add-header.md);
- можно формировать  с помощью атрибута [http-expire-time-delta](../reference/xscript.md#http-expire-time-delta) тега [\<xscript\>](../reference/xscript.md);
- метод CORBA-блока может напрямую добавлять заголовки в объект [Request](request-ov.md), передаваемый в качестве параметра.

{% note info %}

Eсли заголовок с одним и тем же именем выставлен методом CORBA-блока и тегом `<add-headers>`, пользователю будет возвращено значение, заданное в `<add-headers>`.

{% endnote %}


### Узнайте больше {#learn-more}
* [Кэширование результата работы XScript-блока](../concepts/block-results-caching.md)
* [http://www.w3.org/Protocols/rfc2616/rfc2616.html](http://www.w3.org/Protocols/rfc2616/rfc2616.html)
* [http://www.httpheaders.com/httpheadersandcaching.asp](http://www.httpheaders.com/httpheadersandcaching.asp)