# Приводимые типы параметров

Приводимые типы параметров служат для извлечения части данных из базовых объектов с приведением типа во время обработки [XScript-блока](block-ov.md).


Имя типа должно быть указано в атрибуте параметра type, в атрибуте as - [простой тип параметра](parameters-simple-ov.md), к которому нужно привести значение, а внутри тега параметра - имя поля данных объекта или структуры. Если объект не располагает запрашиваемыми данными (например, контейнер не содержит указанной пары "имя-значение", нет нужного заголовка запроса и т.п.), то методу передаётся значение по умолчанию, указанное в атрибуте default. Если оно также не задано, то передаётся значение по умолчанию соответствующего простого типа. {#as}

Приводимые типы делятся на две группы: универсальные и специализированные.


## Универсальные приводимые типы {#universal}

В эту группу входят типы, которые могут извлекать любые поля данных, приводимые к любым простым типам, из сложных объектов XScript, в зависимости от значения внутри тега [\<param\>](../reference/param.md).

#|
|| Тип адаптера | Описание | Пример использования ||
|| ProtocolArg {#protocol-arg} | Тип параметра [ProtocolArg](../appendices/protocol-arg.md) позволяет использовать переменные окружения протокола FastCGI и содержимое ряда HTTP-заголовков в качестве параметров XScript. | ``` <param type="ProtocolArg">port</param> ```

 В приведенном примере выполняется получение номера порта, на который пришел запрос пользователя. ||

|| QueryArg | Позволяет извлечь из объекта [Request](../concepts/request-ov.md) и передать методу один из пользовательских параметров, полученных в URL. 
| ```<param type="QueryArg" as="String">my_data</param> ``` 
```<param type="QueryArg" as="Long" default="10">job_id</param> ```
||

|| StateArg {#statearg} | Позволяет извлечь из объекта [State](../concepts/state-ov.md) и передать методу одну из ячеек данных, ранее сохранённых в контейнере. | ```<param type="StateArg" as="String" default="/">xml_url</param> ```
||
|| VHostArg {#vhostex} | Позволяет передать номера портов _noxslt-port_ (при запросе на данный порт не накладываются ни основное, ни перблочные XSL-преобразования) и _alternate-port_ (при запросе на данный порт не накладывается основное XSL-преобразования), а также переменные окружения веб-сервера с префиксом "XSCRIPT_".<br/><br/>Представление переменных окружения в XScript отличается от того вида, в котором они прописаны в конфигурационном файле Lighttpd: строчные (маленькие) буквы заменяются на заглавные (большие), а символ "-" - на подчеркивание ("_"). Например, переменная окружения `XSCRIPT_super-var` в XScript будет доступна в виде `XSCRIPT_SUPER_VAR`.

При отсутствии запрашиваемой переменной возвращается пустая строка, а при запросе переменной с именем без префикса "XSCRIPT_" - сообщение об ошибке.

Кроме того, с помощью VHostArg можно получить значение параметра [конфигурационного файла](../appendices/config.md). Для этого в качестве значения параметра типа VHostArg необходимо указать путь к интересующей настройке (см. пример). 
| 
1. В приведенном примере выполняется получение портов `noxslt-port` и `alternative-port` и переменной окружения XSCRIPT_VAR_1.

     ``` 
     <param type="VHostArg">noxslt-port</param>
 
     <param type="VHostArg">alternate-port</param>
 
     <param type="VHostArg">XSCRIPT_VAR_1</param> 
     ```

     1. Допустим, конфигурационный файл содержит следующие настройки:

     ``` 
     <xscript>
      ...
      <noxslt-port>8065</noxslt-port>
      <auth>
          <root-domain>yandex.ru</root-domain>
      </auth>
      ...
     </xscript> 
     ```

     Тогда доступа к значениям `noxslt-port` и `root-domain` можно получить следующим образом:

     ``` 
     <param type="VHostArg">noxslt-port</param>
 
     <param type="VHostArg">auth/root-domain</param> 
     ```
||
|#


## Специализированные приводимые типы {#special}

Передают методу только информацию определённого типа или только одно поле данных базового объекта (например, куки пользователя).

#|
|| Тип адаптера | Описание | Пример использования ||
|| AuthKarma | Передает информацию о карме пользователя (целое число). Для неавторизованных пользователей значение кармы равно нулю. | ``` <param type="AuthKarma"/> ``` ||
|| AuthKarmaStatus | Передает информацию о статусе кармы пользователя (целое число). Для неавторизованных пользователей значение статуса кармы равно нулю. | ``` <param type="AuthKarmaStatus"/> ``` ||
|| BanTime | Передает время в Unix-формате (в виде целого числа типа Long), после которого учетная запись пользователя официально считается "спамовой". Значение BanTime получается из Blackbox. Для "неспамовых" учетных записей и неавторизованных пользователей это значение равно нулю. | 
```
 <mist>
      <method>set_state_long</method>
      <param type="String">ban_time</param>
      <param type="BanTime"/>
 </mist> 
 ```
 ||
 || CheckSecretKey {#check-secret-key} | 
 Содержит флаг, выставляющийся по результатам сравнения [секретного ключа](secret-key.md) со значением указанного параметра. Если они совпадают, возвращается булевское значение "1", если нет - "0". | ```<param type="CheckSecretKey">sk</param> ```

 В приведенном примере значение параметра запроса `sk` сравнивается со сгенерированным секретным ключом.

 CheckSecretKey удобно использовать в [Guard](../reference/guard.md)-условиях, например, так:

 ``` 
 <lua>
      <guard-not type="CheckSecretKey">sk</guard-not>
      <![CDATA[
          xscript.stopBlocks();
          xscript.dropStylesheet();
          xscript.suppressBody();
          xscript.response:setStatus(403);
      ]]>
 </lua>
  ```

  Данный Lua-блок выполнится, если значение секретного ключа не совпадает со значением параметра `sk`. ||

|| Cookie | Передаёт одну из строк cookies. Обычно приводится к String. | ```<param type="Cookie">yandex_cookie_x</param>``` ||
|| EasySecretKey {#easy-secret-key} | Содержит простой [секретный ключ](secret-key.md), с помощью которого можно подписывать запросы. | 

```
<mist method="set_state_string">
      <param type="String">skey</param>
      <param type="EasySecretKey"/>
 </mist> 
 ```
||
|| HTTPHeader | Передаёт один из заголовков HTTP-запроса. То же самое можно сделать при помощи [Mist-блока](block-mist-ov.md). Изменить заголовки запроса нельзя. | 
```<param type="HTTPHeader">host</param> ``` ||
|| IsLite | Возвращает значение "true" для [Lite-пользователей](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About). Для полностью авторизованных и незарегистрированных пользователей возвращает значение "false". | 

  ``` 
 <mist>
       <method>set_state_long</method>
       <param type="String">is_lite</param>
       <param type="IsLite"/>
 </mist> 
  ```

||
|| LiteLogin | 
Передает логин для любого зарегистрированного пользователя (полностью авторизованного или [Lite-пользователя](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About)). | 

``` 
<mist>
      <method>set_state_string</method>
      <param type="String">var</param>
      <param type="LiteLogin"/>
 </mist> 
 ```
 ||
|| LiteRegName | 
Содержит логин, который пользователь ввел при регистрации. RegName может отличаться от Login из-за наличия в Паспорте правил, запрещающих использовать в логине определенные символы, которые тем не менее могут быть указаны пользователем при регистрации. Может использоваться для любого зарегистрированного пользователя (полностью авторизованного или [Lite-пользователя](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About)). | 

``` 
<mist>
       <method>set_state_string</method>
       <param type="String">reg_name</param>
       <param type="LiteRegName"/>
 </mist> 
 ``` 
 ||

|| LiteUID | Передает UID для любого зарегистрированного пользователя (полностью авторизованного или [Lite-пользователя](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About)). | ```<param type="LiteUID" as="String"/> ``` ||

|| _LocalArg_ {#localarg}| Предоставляет доступ к контейнеру LocalArgs, в который записываются параметры [Local-блока](block-local-ov.md). | ``` <param type="LocalArg">name</param> ``` ||

|| Login | Передает логин авторизованного пользователя. | 
 
 ``` 
 <mist>
      <method>set_state_string</method>
      <param type="String">var</param>
      <param type="Login"/>
 </mist> 
 ``` 
||
|| RegName | Содержит логин, который пользователь ввел при регистрации. RegName может отличаться от Login из-за наличия в Паспорте правил, запрещающих использовать в логине определенные символы, которые тем не менее могут быть указаны пользователем при регистрации. Может использоваться только для полностью авторизованного пользователя. | 

``` 
<mist>
       <method>set_state_string</method>
       <param type="String">reg_name</param>
       <param type="RegName"/>
 </mist> 
 ``` 
 ||
|| SecretKey {#secret-key} | 
Содержит [секретный ключ](secret-key.md), с помощью которого можно подписывать запросы. | 

``` 
<mist method="set_state_string">
      <param type="String">skey</param>
      <param type="SecretKey"/>
 </mist> 
 ``` 
 ||
 
|| _SecureUID_ | Передает идентификатор пользователя UID, если пользователь прошел платежную авторизацию. В противном случае возвращает 0. | ```<param type="SecureUID"/> ``` ||
|| UID | Передаёт идентификатор пользователя UID (для [Lite-пользователя](https://docs.yandex-team.ru/authdevguide/concepts/LiteAuth_About) возвращает 0). | ```<param type="UID" as="String"/> ``` ||
|#

### Узнайте больше {#learn-more}
* [Типы параметров](../concepts/parameters-ov.md)
* [Все типы параметров методов, вызываемых в XScript-блоках](../appendices/block-param-types.md)

