# Типы параметров

Все описанные типы параметров, за исключением сложных типов, могут использоваться в любых [XScript-блоках](block-ov.md).

Список и типы параметров должны соответствовать вызываемому методу блока.

Список и типы параметров метода CORBA-блока должны соответствовать интерфейсу запрашиваемого объекта, который объявлен в соответствующем файле `.idl`. Если интерфейс объекта указан в блоке неверно, в XML-файле будет размещено сообщение об [ошибке](error-diag-ov.md).

Названия типов не зависят от регистра (case-insensitive).

Параметр имеет одно и то же значение в любом месте XML-файла. Исключение: [State](state-ov.md), StateArg: они могут в разное время возвращать разные значения.

Для задания параметра используется тег [param](../reference/param.md). Кроме того, существует тег [query-param](../reference/query-param.md), использующийся только в HTTP-блоке и предназначенный для задания параметра HTTP-запроса.

## Классификация типов параметров {#param-type-classif}

Типы параметров подразделяются на следующие группы:

- [простые типы](parameters-simple-ov.md): передаются объекту по значению, то есть константами, заданными в XScript-блоке. Простыми типами являются Boolean, String, Double, Long и т.д.;
- [сложные типы](parameters-complex-ov.md): были введены для использования в CORBA-блоках и применяются только там и в Auth-блоках. Передаются серванту, который может читать и записывать в них данные. Сложными типами являются Auth, Request, State, CustomMorda и т.д.;
- [приводимые типы (адаптеры)](parameters-matching-ov.md): такие типы параметров позволяют привести отдельные поля данных базовых объектов и структур к простым типам для передачи их CORBA-серванту или HTTP-серверу, являются адаптерами сложных типов к простым. К приводимым типам относятся QueryArg, StateArg, ProtocolArg, Cookie, UID и т.д.;
- [специальные типы](parameters-other-ov.md): Hostname и HTTPUser.

## Приведение типов {#param-type-match}

Некоторые типы (AuthKarma, AuthKarmaStatus, UID, LiteUID, Cookie, HTTPHeader, ProtocolArg, QueryArg, StateArg) можно приводить к простым на уровне XScript. Например, ID, сохранённые в QueryArg, можно передать, приведя к  прямо в блоке, как показано в приведенном ниже примере.

Атрибут  приводит параметр только к простому типу. Для не CORBA-блоков значение атрибута  игнорируется и параметр всегда приводится к строковому типу (как если бы было указано `as="String"`). Это правило применяется во всех стандартных блоках XScript, однако при разработке собственных блоков можно реализовать собственный алгоритм приведения типа.

Если XScript не может выполнить приведение к числу, то возвращается значение 0. Исключения никогда не генерируются.

```
<param type="QueryArg" as="Long">my_ID</param>
```

### Узнайте больше {#learn-more}
* [Все типы параметров методов, вызываемых в XScript-блоках](../appendices/block-param-types.md)
* [param](../reference/param.md)
