# Перблочное XSL-преобразование

XSL-преобразование может накладываться не только на весь XML-файл, но и на результаты работы отдельного XScript-блока (перблочное преобразование - "one XSL transformation _per block_"). После его наложения в обработке XML-файла используется уже результат работы преобразования.

Перблочное XSL-преобразование поддерживается для всех [типов блоков](block-ov.md) и указывается в атрибуте [xslt](../appendices/attrs-ov.md#xslt) тега блока.

На выходе перблочного преобразования должен быть получен корректный XML-фрагмент, который затем обрабатывается на стадии основного XSL-преобразования.

Ниже приведен пример определения в XML-файле перблочного XSL-преобразования с передачей ему параметров с помощью свойства [xslt-param](../reference/xslt-param.md).

```
<block xslt="xml/get/calendar.xsl">
   <name>Yandex/Postcards.id</name>
   <method>getMonthCalendar</method>
   <param type="StateArg" as="Long">date_0</param>
   <param type="StateArg" as="Long">date_1</param>
   <param type="Tag"/>
   <xslt-param id="date_x" type="QueryArg">date</xslt-param> 
</block>
```

Существует возможность использовать XSL-преобразование, записанное в переменную контейнера [State](state-ov.md). Для этих целей используется тег [\<xslt\>](../reference/xslt-tag.md), в котором обязательно должен быть указан атрибут `type="StateArg"`.

В связи с тем, что имя перблочного преобразования используется при формировании ключа для [tagged-кеша](block-results-caching.md), используется XSL, определенный до начала работы блока, и в процессе работы блока он измениться не может.

```
<mist method="set_state_string">
     <param type="String">xsl</param>
     <param type="String">example.xsl</param> 
</mist> 
<file>
     <xslt type="StateArg">xsl</xslt>
     <method>load</method>
     <param type="String">file.xml</param> 
</file>
```

Чтобы получить страницу на XScript без перблочного XSL-преобразования, в URL запрашиваемой страницы необходимо указать номер порта `noxslt-port`, который задается в [файле настроек](../appendices/config.md) XScript. При этом основное XSL-преобразование также будет отключено.

Если в результате своего выполнения блок возвращает ошибку [\<xscript_invoke_failed\>](error-diag-ov.md), перблочное XSL-преобразование не накладывается.


## Достоинства {#PerBlock-advant}

Перблочное преобразование обладает следующими достоинствами:

- ускоряет обработку страницы, так как позволяет сразу преобразовать результат работы блока в статические данные;
- делает преобразование более гибким за счёт обработки разных блоков с помощью разных XSL;
- результаты перблочного преобразования кэшируются. При использовании в блоке структуры [Tag](tag-ov.md) или атрибута [tag](../appendices/attrs-ov.md#tag) блок попадает в кэш с уже наложенным перблочным преобразованием;
- перблочное преобразование упрощает обработку за счёт уменьшения размеров XML-дерева, полученного в результате работы блока.

### Узнайте больше {#learn-more}
* [Обработка XScript-блока](../concepts/block-handling-ov.md)
* [XScript-блок в файле XSL-преобразования](../concepts/xscript-block-in-xsl.md)
* [Основное XSL-преобразование](../concepts/general-transformation-ov.md)