# Структура Tag: параметры кэширования

## Определение {#definition}

Структура _Yandex::Tag_ содержит информацию о кэшировании ответа серванта на вызов данного метода.

Tag состоит из трех полей: `lastModified` (время последнего изменения закэшированного контента), `expireTime` (время инвалидации кэша) и `notModified` (флаг, указывающий что закэшированный контент не был изменен).

Рекомендуется применять Tag для повышения производительности.

Структура Tag описана в [tag.idl](https://svn.yandex.ru/websvn/wsvn/common/idl/trunk/tag/idl/tag.idl).


## Особенности работы {#workdetails}

При вызове метода CORBA-серванта, результат которого отсутствует или не валиден в кэше, передается пустая структура Tag. Сервант решает, как долго данные этого запроса будут валидны, и заполняет Tag. XScript создаёт кэш по значениям параметров и названию метода, чтобы потом можно было сравнить новый вызов с запомненным. При следующем вызове такого же блока с теми же параметрами и при условии, что установленный ранее сервантом срок валидности ещё не истёк, XScript выдаёт результат работы блока из кэша. Также, если сервант возвращает поле `Not Modified`, XScript извлекает результаты работы блока из кэша.


## Особенности использования {#usagedetails}

Доступ к структуре Tag осуществляется посредством параметра Tag [структурного типа](parameters-complex-ov.md).

Параметр Tag всегда задается последним в списке параметров и может использоваться только в CORBA-, HTTP- и File-блоках. При этом структура Tag создается только для CORBA-блоков, а для других блоков параметрами кэширования управляет сам XScript.

Аналогом параметра Tag является атрибут [tag](../appendices/attrs-ov.md#tag), так же использующийся в CORBA-, HTTP- и File-блоках. Сравнение параметра Tag и атрибута tag смотрите в разделе [Кэширование результатов работы XScript-блока](../concepts/block-results-caching.md).

Не стоит использовать Tag для методов, которые принимают [State](state-ov.md), [Auth](auth-ov.md) и [Request](request-ov.md).


## Время жизни {#lifetime}

В памяти структура Tag существует в течение обработки блока, при этом параметры кэширования, из которых она состоит, сохраняются в кэше вместе с закэшированным результатом работы блока.


## Пример использования {#example}

```
<block>
    <name>Yandex/Blogs/Blogger.id</name>
    <method>GetAvatarsProxies</method>
    <param type="Tag"/>
</block>
```

### Узнайте больше {#learn-more}
* [Кэширование результата работы XScript-блока](../concepts/block-results-caching.md)