# XML-файл на XScript

Данный раздел содержит общие сведения о структуре и правилах создания XML-файлов на XScript.

XScript применяется для расширения возможностей веб-страниц, исходные файлы которых написаны на XML. Такие страницы состоят из динамической и статической частей.

_Динамическая часть страницы_ содержит [блоки](block-ov.md), которые обрабатываются средствами XScript.

_Статическая часть страницы_ содержит прочие элементы, обрабатываемые на уровне основного XSL-преобразования, игнорирующаяся средствами XScript.

XML-файл на XScript должен представлять собой правильно сформированный (_well-formed_) XML-документ. Хотя в качестве корневого элемента может использоваться произвольный тег, обычно используется тег _\<page\>_.

Преобразование XML в HTML или другой формат осуществляется динамически с помощью XSL-преобразований на стороне веб-сервиса.

Ниже приведен пример XML-страницы на XScript (в общем виде):

```
<?xml version="1.0" encoding="windows-1251"?>
<?xml-stylesheet type="text/xsl" href="xsl/index.xsl"?>
<page xmlns:xi="http://www.w3.org/2001/XInclude" pager_offset="0" name="index">
        <xscript>
           ...
        </xscript>
        ...
        <!--Статические элементы/-->
        <static-element-1/>
          ...
        <static-element-n/>
        ...
        <!--XScript-блоки/-->
        <http>
           ...
        </http>
        <mist>
           ...
        </mist>
        <geo-block>
           ...
        </geo-block>
        ... 
        ...
        ...
        <xi:include href="..."/>
</page>
```

Статические элементы, блоки, тег [`<xscript>`](../reference/xscript.md) и конструкция [`<xi:include>`](../reference/xi-include.md) могут быть расположены в любом месте страницы внутри корневого элемента.

### Узнайте больше {#learn-more}
* [Как создать веб-страницу с использованием XScript](../tasks/how-to-design-page-with-xscript.html)
* [Пример XML-файла на XScript](../appendices/example-page.html)
* [Обработка запроса](./xscript-functionality.html)