# block

Содержит один CORBA-блок.

## Содержит {#contains}

[guard](guard.md), [guard-not](guard-not.md), [xpath](xpath.md), [method](method.md), [param](param.md), [name](name.md) и [nameref](nameref.md).

## Содержится в {#contained-in}

корневом элементе (\<page\> или другом).

## Атрибуты {#attrs}

#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| elapsed-time | Если данному атрибуту присвоено значение "yes", в корневой элемент результата работы блока будет добавлен атрибут elapsed-time со значением, указывающим время работы блока в секундах. | "yes" или "no" | no ||
|| guard | Условное выполнение блока.

Содержит имя переменной в контейнере [State](../concepts/state-ov.md), значение которой определяет, будет ли выполен блок.

Использование этого атрибута аналогично использованию в блоке тега [guard](../reference/guard.md) без атрибутов `type` и `value`. | Строка | - ||
|| guard-not | guard-отрицание.

Условное выполнение блока.

Содержит имя переменной в контейнере [State](../concepts/state-ov.md), значение которой определяет, будет ли выполен блок.

Использование этого атрибута аналогично использованию в блоке тега [guard-not](../reference/guard-not.md) без атрибутов `type` и `value`. | Строка | - ||
|| id | Идентификатор блока. | Строка | - ||
|| method | Имя метода, который должен быть вызван при обработке блока. | Строка | - ||
|| remote-timeout | Время ожидания ответа на запрос от back-end-а. Можно установить значение этого атрибута большим, чем атрибута _timeout_, для того чтобы, даже когда время обработки блока истекло, на удаленный запрос можно было получить результат, положить его в кэш, и при дальнейших вызовах считывать результаты из кэша. По умолчанию совпадает с timeout-ом. | Миллисекунды | - ||
|| retry-count | Количество повторных попыток получения результата от удаленного сервера в случае ошибок соединения. Повторная попытка может быть сделана только до истечения `timeout`. Время выполнения попытки равно `remote-timeout`. | Целое число | 0 ||
|| tag | Время кэширования результата работы блока. | Секунды | - ||
|| threaded | Если данному атрибуту присвоено значение "yes", блок обрабатывается асинхронно (в отдельном потоке). Значение "no" имеет смысл устанавливать в случае, когда необходимо выключить асинхронность обработки конкретного запроса при установленном атрибуте [all-threaded](../reference/xscript.md#all-treaded) ="yes". | "yes" или "no" | no ||
|| timeout | Таймаут выполнения блока (в миллисекундах). По умолчанию этот таймаут равен 5000 миллисекундам (5 сек.). | Целое число | - ||
|| xmlns | Неймспейс, который будут использоваться в XPath-выражении при отработке тега [\<xpath\>](../reference/xpath.md) и атрибута xpointer. | Строка | - ||
|| xpointer | [XPointer](../appendices/xpointer.md)-выражение, накладывающееся на результат работы блока. | Строка. Например, ""`//BBB`"" | - ||
|| xslt | Относительный или абсолютный путь к XSL-файлу перблочного преобразования. | Строка. Например, "`/usr/local/www/common/ docbook/docbook_validator.xsl`" | - ||
|#

## Пример {#example}

```
<block threaded="yes" timeout="6000">
    <name>Yandex/Finder.id</name>
    <method>findObject</method>
    <param type="State"/>
    <param type="String">Yandex/Mist.id</param>
    <param type="String">objname</param>
</block>
```

### Узнайте больше {#learn-more}
* [CORBA-блок](../concepts/block-corba-ov.md)