# file

Содержит один File-блок.

## Содержит {#contains}

[guard](guard.md), [guard-not](guard-not.md), [xpath](xpath.md), [method](method.md) и [param](param.md).

## Содержится в {#contained-in}

корневом элементе (\<page\> или другом).

## Атрибуты {#attrs}
#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| elapsed-time | Если данному атрибуту присвоено значение "yes", в корневой элемент результата работы блока будет добавлен атрибут elapsed-time со значением, указывающим время работы блока в секундах. | "yes" или "no" | no ||
|| guard | Условное выполнение блока.

Содержит имя переменной в контейнере [State](../concepts/state-ov.md), значение которой определяет, будет ли выполен блок.

Использование этого атрибута аналогично использованию в блоке тега [guard](../reference/guard.md) без атрибутов `type` и `value`. | Строка | - ||
|| guard-not | guard-отрицание.

Условное выполнение блока.

Содержит имя переменной в контейнере [State](../concepts/state-ov.md), значение которой определяет, будет ли выполен блок.

Использование этого атрибута аналогично использованию в блоке тега [guard-not](../reference/guard-not.md) без атрибутов `type` и `value`. | Строка | - ||
|| id | Идентификатор блока. | Строка. | - ||
|| ignore-not-existed | Если этому свойству присвоено значение "yes" и запрашиваемый файл отсутствует, то File-блок ничего не вернет, обработка страницы продолжится, а сообщение об отсутствии файла будет выведено в лог XScript с уровнем INFO. | "yes" или "no" | no ||
|| method | Имя метода, который должен быть вызван при обработке блока. | Строка | - ||
|| tag | Время кэширования результата работы блока. Может также иметь значение "yes", что означает неопределенное время кэширования (см. [Кэширование результатов работы XScript-блока](../concepts/block-results-caching.md)). | Секунды, "yes" | - ||
|| threaded | Если данному атрибуту присвоено значение "yes", блок обрабатывается асинхронно (в отдельном потоке). Значение "no" имеет смысл устанавливать в случае, когда необходимо выключить асинхронность обработки конкретного запроса при установленном атрибуте [all-threaded](../reference/xscript.md#all-treaded) ="yes". | "yes" или "no" | no ||
|| timeout | Таймаут выполнения блока (в миллисекундах). По умолчанию этот таймаут равен 5000 миллисекундам (5 сек.). | Целое число. | - ||
|| xmlns | Неймспейс, который будут использоваться в XPath-выражении при отработке тега [\<xpath\>](../reference/xpath.md) и атрибута xpointer. | Строка | - ||
|| xpointer | [XPointer](../appendices/xpointer.md)-выражение, накладывающееся на результат работы блока. | Строка. Например, ""`//BBB`"" | - ||
|| xslt | Относительный или абсолютный путь к XSL-файлу перблочного преобразования. | Строка. Например, "`/usr/local/www/common/ docbook/docbook_validator.xsl`" | - ||
|#


## Пример {#example}

```
<file ignore-not-existed="yes">
   <method>invoke</method>
   <param type="String">/usr/local/www/project/index.xml</param>
</file>
```

### Узнайте больше {#learn-more}
* [File-блок](../concepts/block-file-ov.md)
* [Методы File-блока](../appendices/block-file-methods.md)
