# guard

Определяет условие при выполнении которого обработка блока не будет прервана. Блок может содержать несколько тегов `<guard>` и [`guard-not`](guard-not.md) и обрабатывается полностью при выполнении всех условий guard и невыполнении всех условий guard-not.

Условие задается с помощью указания имени переменной (обязательно), ее типа (опционально) и значение для сравнения (опционально).

Если переменная не определена, условие считается не выполненным.

Если тип не указан, предполагается, что переменная находится в контейнере [State](../concepts/state-ov.md).

Если значение для сравнения не задано, условие будет считаться выполненным в следующих случаях:

1. Если переменная имеет тип String и ее значение отлично от пустой строки.
1. Если переменная имеет тип Double и ее значение отлично от нуля более чем на 2.22045E-16.
1. Если переменная имеет целый или булевый тип и ее значение отлично от нуля.
1. Если переменная имеет тип Map или Array и структура содержит хотя бы один элемент.
1. Если тип переменной относится к [приводимым типам](../concepts/parameters-matching-ov.md) (UID, LiteUID, SecureUID, IsLite, Login, LiteLogin, RegName, LiteRegname, CheckSecretName и пр.) и значение переменной отлично от нуля.

Если значение для сравнения задано, блок будет выполнен в случае совпадения значения переменной и значения для сравнения. При этом переменная приводится к типу String.

## Содержит {#contains}:

Данный тег не может содержать других тегов.

## Содержится в {#contained-in}

тегах любых [блоков](../concepts/block-ov.md).

## Атрибуты {#attrs}

#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| type | Опциональный атрибут.

Тип переменной, значение которой проверяется в `<guard>`.

Если данный атрибут отсутствует, считается, что переменной находится в контейнере State. | Строка. Возможные значения: QueryArg, StateArg, Cookie, HttpHeader, UID, LiteUID, Login и LiteLogin и пр. | - ||
|| value | Опциональный атрибут.

Значение для сравнения.

Если значение переменной совпадает со значением данного атрибута, блок будет выполнен. | Любое значение. | - ||
|#

## Примеры {#examples}

В приведенном ниже примере блок будет выполнен, если в query (строке параметров) HTTP-запроса определена переменная `var1`, переменная `var2` из контейнера State имеет истинное значение, отсутствует кука `yandex_cookie_x` и пользователь имеет полноценную (не Lite) авторизацию.

```
<mist>
     <guard type="QueryArg">var1</guard>
     <guard type="StateArg">var2</guard>
     <guard-not type="Cookie">yandex_cookie_x</guard-not>
     <guard type="UID"/>
     <method>set_state_string</method>
     <param type="String">var</param>
     <param type="String">sss</param>
</mist>
```

В приведенном ниже примере блок будет выполнен только в том случае, если в HTTP-запросе присутствует параметр `id` со значением 12.

```
<mist>
     <guard type="QueryArg" value="12">id</guard>
     <method>set_state_string</method>
     <param type="String">var</param>
     <param type="String">my_id</param>
</mist>
```

### Узнайте больше {#learn-more}
* [Атрибут guard](../appendices/attrs-ov.html#attrs-ov__guard)
* [guard-not](../reference/guard-not.md)
* [Общий процесс обработки запроса](../concepts/request-handling-ov.md)
* [Приводимые типы параметров](../concepts/parameters-matching-ov.md)