# http

Содержит один HTTP-блок.

## Содержит {#contains}

[guard](guard.md), [guard-not](guard-not.md), [xpath](xpath.md), [method](method.md), [param](param.md), [query-param](query-param.md), [header](header.md).

## Содержится в {#contained-in}

корневом элементе (\<page\> или другом).

## Атрибуты {#attrs}

#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| elapsed-time | Если данному атрибуту присвоено значение "yes", в корневой элемент результата работы блока будет добавлен атрибут elapsed-time со значением, указывающим время работы блока в секундах. | <q>yes</q> или <q>no</q>. | <q>no</q> ||
|| encoding | Кодировка запрошенного по HTTP XML-документа. Из нее полученный документ переводится в кодировку UTF-8. | Строка. | - ||
|| follow-redir | Если <q>yes</q>, то HTTP-блок следует редиректу. | <q>yes</q> или <q>no</q>. | <q>no</q> ||
|| guard | Условное выполнение блока.

Содержит имя переменной в контейнере [State](../concepts/state-ov.md), значение которой определяет, будет ли выполен блок.

Использование этого атрибута аналогично использованию в блоке тега [guard](../reference/guard.md) без атрибутов `type` и `value`. | Строка. | - ||
|| guard-not | guard-отрицание.

Условное выполнение блока.

Содержит имя переменной в контейнере [State](../concepts/state-ov.md), значение которой определяет, будет ли выполен блок.

Использование этого атрибута аналогично использованию в блоке тега [guard-not](../reference/guard-not.md) без атрибутов `type` и `value`. | Строка. | - ||
|| id | Идентификатор блока. | Строка. | - ||
|| keep-alive | Включение/отключение поддержания HTTP-соединения. | <q>yes</q> или <q>no</q>. | Определяется [глобальными настройками](../appendices/config-params.md#xscript-http-config) модуля. ||
|| load-entities | Загружать сущности из xml=ответа. | <q>yes</q> или <q>no</q>. | Определяется [глобальными настройками](../appendices/config-params.md#xscript-http-config) модуля. ||
|| method | Имя метода, который должен быть вызван при обработке блока. | Строка. | - ||
|| parse | Если данному атрибуту присвоено значение <q>text</q>, то приходящие данные интерпретируются как plain text, если значение атрибута <q>xml</q>, приходящие данные интерпретируются как XML, независимо от значения поля Content-Type http-заголовка. | <q>text</q> или <q>xml</q>. | - ||
|| print-error-body | Если данному атрибуту присвоено значение "yes", то в случае HTTP-ответа со статусом 400-499 или 500-599, [сообщение об ошибке](../concepts/error-diag-ov.md) xscript_invoke_failed будет содержать тело ответа HTTP-сервера. | <q>yes</q> или <q>no</q>. | <q>no</q> ||
|| proxy | Если этому атрибуту присвоено значение "yes", XScript будет передавать в HTTP-запросе к третьей стороне HTTP-заголовки запроса, пришедшего от пользователя. | <q>yes</q> или <q>no</q>. | <q>no</q> ||
|| proxy-url | URL входной точки в [Zora](https://wiki.yandex-team.ru/robot/manual/zora). Используется вместе с атрибутами zora-source и zora-timeout | Строка. Например, <q>http://zora.yandex.net:8166</q>. | - ||
|| remote-timeout | Время ожидания ответа на запрос от back-end-а . Можно установить значение этого атрибута большим, чем атрибута _timeout_, для того чтобы, даже когда время обработки блока истекло, на удаленный запрос можно было получить результат, положить его в кэш, и при дальнейших вызовах считывать результаты из кэша. По умолчанию совпадает с timeout-ом. | Миллисекунды. | - ||
|| retry-count | Количество повторных попыток получения результата от удаленного сервера в случае ошибок соединения. Повторная попытка может быть сделана только до истечения `timeout`. Время выполнения попытки равно `remote-timeout`. | Целое число. | 0 ||
|| tag | Время кэширования результата работы блока. Может также иметь значение "yes", что означает неопределенное время кэширования (см. [Кэширование результатов работы XScript-блока](../concepts/block-results-caching.md)). | Секунды. | - ||
|| threaded | Если данному атрибуту присвоено значение "yes", блок обрабатывается асинхронно (в отдельном потоке). Значение "no" имеет смысл устанавливать в случае, когда необходимо выключить асинхронность обработки конкретного запроса при установленном атрибуте [all-threaded](../reference/xscript.md#all-treaded) ="yes". | <q>yes</q> или <q>no</q>. | <q>no</q> ||
|| text | Если установлен, то ответ возвращается без изменений. | <q>yes</q> или <q>no</q>. | <q>no</q> ||
|| timeout | Таймаут выполнения блока (в миллисекундах). По умолчанию этот таймаут равен 5000 миллисекундам (5 сек.). | Целое число. | - ||
|| xmlns | Неймспейс, который будут использоваться в XPath-выражении при отработке тега [\<xpath\>](../reference/xpath.md) и атрибута xpointer. | Строка. | - ||
|| xpointer | [XPointer](../appendices/xpointer.md)-выражение, накладывающееся на результат работы блока. | Строка. Например, ""`//BBB`"". | - ||
|| xslt | Относительный или абсолютный путь к XSL-файлу перблочного преобразования. | Строка. Например, "`/usr/local/www/common/ docbook/docbook_validator.xsl`". | - ||
|| x-forwarded-for | Устанавливает заголовок X-Forwarded-For. | Строка. | - ||
|| zora-source | Источник запроса. | Строка. Например, <q>any</q>. | - ||
|| zora-timeout | Время ожидания ответа от [Zora](https://wiki.yandex-team.ru/robot/manual/zora) в секундах. | Целое число. Например, 30. | - ||
|#

## Примеры {#examples}

```
<http threaded="yes" timeout="6000">
     <method>getBinaryPage</method>
     <param type="String">http://www.ya.ru/1.pdf</param>
</http>
```

Пример скачки через Zora:

```
<page xmlns:x="http://www.yandex.ru/xscript" xslt-dont-apply="yes">
    <x:http method="get_http">
        <x:proxy-url>http://zora.yandex.net:8166</x:proxy-url>
        <x:zora-source>mapsapi</x:zora-source>
        <x:zora-timeout>30</x:zora-timeout>

        <x:param type="String">http://dist.yandex.ru/</x:param>
    </x:http>
</page>
```

### Узнайте больше {#learn-more}
* [HTTP-блок](../concepts/block-http-ov.md)
* [Методы HTTP-блока](../appendices/block-http-methods.md)