# query-param

Задаёт параметр HTTP-запроса, выполняемого с помощью HTTP-блока. Параметр добавляется в запрос в URL-кодированном виде.

## Содержит {#contains}

Данный тег не может содержать других тегов.

## Содержится в {#contained-in}

[http](http.md).

## Атрибуты {#attrs}

#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| id | Имя параметра запроса. Обязательный атрибут. | Строка, длиной не более 128 символов, состоящая из символов, принадлежащих множеству 'a'..'z','A'..'Z',0..9,'-','\_' | - ||
|| type | Тип параметра вызываемого метода. | См. [Все типы параметров методов, вызываемых в XScript-блоках](../appendices/block-param-types.md) | - ||
|| as | Тип, к которому необходимо привести значение параметра. В атрибуте `type` указывается приводимый тип (адаптер), а в атрибуте `as` - простой тип, к которому XScript приведёт значение. | Название одного из простых типов параметров: Boolean, Double, Long, LongLong, String, ULong, ULongLong. | String ||
|| default | Значение параметра по умолчанию. Используется, если значение не задано явно или его невозможно извлечь из объекта или структуры. | Зависит от типа параметра. | - ||
|| urlencode | Кодировка, в которую преобразуется параметр запроса (перед URL-кодированием). | Строка. Значение <q>yes</q> интерпретируется как <q>UTF-8</q>. Значение <q>no</q> отключает URL-кодирование. | <q>UTF-8</q> ||
|| allow-empty | Передавать ли параметр, если его значение пусто. | Строка. Возможные значения <q>yes</q> или <q>no</q>. | <q>no</q> ||
|#

## Пример {#example}

```
<http timeout="10000" proxy="yes">
  <method>getHttp</method>
  <param type="String">http://speller.yandex.net/services/spellservice/checkText</param>
  <query-param id="text" type="String">токой типп</query-param>
  <query-param id="options" type="String">5</query-param>
</http>
```

## Сокращенный синтаксис {#syntax}

Если параметр метода имеет контейнерный тип, ключ в контейнере можно не указывать. В этом случае будет использоваться ключ, совпадающий со значением атрибута `id`. Например, запись

`<query-param id="gid" type="QueryArg"/>`

будет аналогична записи

`<query-param id="gid" type="QueryArg">gid</query-param>`.

### Узнайте больше {#learn-more}
* [Понятие XScript-блока и его типы](../concepts/block-ov.md)
* [Типы параметров](../concepts/parameters-ov.md)
* [method](../reference/method.md)

