# xscript

Содержит параметры обработки XML-файла XScript-ом.

## Содержит {#contains}

[\<add-headers\>](add-header.md) (необязательно) и [xslt-param](xslt-param.md) (необязательно).

## Содержится в {#contained-in}

корневом элементе (\<page\> или другом).

## Атрибуты {#attrs}

#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| _all-threaded_{#all-treaded} | Если указано "yes", то все XScript-блоки в данном XML-файле по умолчанию обрабатываются как асинхронные. | "yes" или "no" | no ||
|| _allow-methods_ | Список допустимых HTTP-методов запроса страницы. В случае, если вызван метод, отличный от указанного, будет возвращена ошибка 405 - "Method not allowed". | Строка. Например, "get" или "post". | - ||
|| _auth-path_ | Значение, присвоенное данному атрибуту переопределяет URL, указанный в [конфигурационном файле](../appendices/config.md) настройку auth-path, (базовый URL Яндекс.Паспорта). | Строка. Например, "http://passport.yandex.ru/passport". | - ||
|| _blackbox-status_{#blackbox-status} | Если данному атрибуту присвоено значение "yes", в результирующем XML-файле элемент `<xscript>` будет заменен на ответ от Blackbox, обернутый тегом `<blackbox>`. | "yes" или "no" | no ||
|| _cache-strategy_{#cache-strategy} | Стратегия и время кэширования страницы, записанные в виде "<имя стратегии кэширования>:<время кэширования>". См. [Стратегии кэширования XML-страниц](../concepts/page-cache-strategies.md). | Строка. | - ||
|| _dont-redirect_ | Если данному атрибуту присвоено значение "yes", пользователь с кукой Session_id, имеющей [статус](https://doc.yandex-team.ru/blackbox/reference/method-sessionid-response.dita) "need_reset", сможет зайти на страницу без обновления куки.

Как правило, применяется на страницах, с которых отправляются POST-запросы. | "yes" или "no" | no ||
|| _force-auth_ | Если данному атрибуту присвоено значение "yes", страница будет показана посетителю только после [паспортной авторизации](../concepts/request-handling-ov.md) и создания объекта [Auth](../concepts/auth-ov.md). Также есть значение "allow-lite", который означает, что Lite-пользователи могут заходить на страницу. | "yes" или "no" | no ||
|| _force-secure-auth_ | Если данному атрибуту присвоено значение "yes", страница будет показана посетителю только после [платежной авторизации](../concepts/request-handling-ov.md) и создания объекта [SecureAuth](../concepts/auth-ov.md). | "yes" или "no" | no ||
|| _http-expire-time-delta_{#http-expire-time-delta} | Устанавливает максимальное время (в секундах), в течение которого данный XML-файл может браться из кэша браузера и не перекомпилироваться. Для отмены кэширования следует установить в качестве значения атрибута 0. | Целое число | 300 ||
|| _need-auth_ | Если данному атрибуту присвоено значение "yes", будет выполнена попытка получить параметры авторизации пользователя, однако даже в случае неудачи пользователь сможет зайти на страницу (если нет других условий, описанных в разделе [Первый этап: инициализация](../concepts/request-handling-init.md)). | "yes" или "no" | no ||
|| _nocookie-support-url_ | Путь для редиректа в случае отсутствия поддержки кук в браузере пользователя. | Строка | - ||
|| _no-auth_ | Если данному атрибуту присвоено значение "yes", авторизация пользователя производиться не будет. Если установлен атрибут `cache-time`, установка данного атрибута обязательна. | "yes" или "no" | no ||
|| _sauth-path_ | Значение, присвоенное данному атрибуту переопределяет URL, указанный в [конфигурационном файле](../appendices/config.md) настройку sauth-path, (базовый URL для безопасной авторизации пользователя). | Строка. Например, "https://passport.yandex.ru/passport". | - ||
|| _xslt-dont-apply_ | Если данному атрибуту присвоено значение "yes", [основное XSL-преобразование](../concepts/general-transformation-ov.md) накладываться не будет. | "yes" или "no" | no ||
|#

## Пример {#example}

```
<xscript all-threaded="yes" cache-strategy="my_cache_strategy:300">

   <add-headers>
      <header name="Cache-Control" value="max-age=0, proxy-revalidate"/>
      <header name="MyHeader" value="qwergwg"/>
   </add-headers>

   <xslt-param id="xslt" type="QueryArg"/>
   <xslt-param id="new" type="QueryArg"/>
   <xslt-param id="as" type="QueryArg"/>

</xscript>
```

### Узнайте больше {#learn-more}
* [Общий процесс обработки запроса](../concepts/request-handling-ov.md)