# xslt-param

Содержит параметры, которые передаются в XSL-преобразование. Значения этих параметров вычисляются в момент наложения преобразования.

Из XML-файлов импортируются только те переменные XSL, которые удовлетворяют следующим требованиям:
- Имя переменной содержит только символы [a-z], [A-Z], [0-9], "_", "-";
- Имя переменной не начинаются с символа "-" или цифры;
- Длина имени не превышает 128 символов;
- Значение переменной не пусто.

Например, такая переменная импортироваться будет:
```
<xsl:variable name="My-Variable" .../>
```

А такая нет: 
```
<xsl:variable name="My.Variable" .../>
```

## Не содержит других элементов. {#not-contains}

## Содержится в {#contained-in}

[xscript](xscript.md) и тегах любых [блоков](../concepts/block-ov.md).

## Атрибуты {#attrs}

#|
|| Наименование | Описание | Тип и варианты значения | Значение по умолчанию ||
|| default | Значение параметра по умолчанию. Используется, если значение не задано явно или его невозможно извлечь из объекта или структуры. | Зависит от типа параметра | - ||
|| id | Имя, под которым переменная будет передана в XSL. | String | - ||
|| type | Тип параметра вызываемого метода. | См. [Все типы параметров методов, вызываемых в XScript-блоках](../appendices/block-param-types.md) | - ||
|#

## Пример {#example}

```
<?xml-stylesheet type="text/xsl" href="xsl/general.xsl"?>
<xscript all-threaded="yes">
    <xslt-param id="http_query" type="ProtocolArg">query</xslt-param>
</xscript>
```

В приведенном примере в основное XSL-преобразование будут передаваться параметры запроса, полученные в составе URL (переменная `query` типа [ProtocolArg](../concepts/parameters-matching-ov.md#protocol-arg)).

## Сокращенный синтаксис {#syntax}

Если параметр имеет контейнерный тип, ключ в контейнере можно не указывать. В этом случае будет использоваться ключ, совпадающий со значением атрибута `id`. Например, запись

`<xslt-param id="gid" type="QueryArg"/>`

будет аналогична записи

`<xslt-param id="gid" type="QueryArg">gid</xslt-param>`.

### Узнайте больше {#learn-more}
* [Основное XSL-преобразование](../concepts/general-transformation-ov.md)
* [Перблочное XSL-преобразование](../concepts/per-block-transformation-ov.md)
* [Как закэшировать результат работы блока с учетом параметра](../tasks/how-to-cache-with-param.md)