# Как проверить значение параметра на принадлежность множеству

Допустим, необходимо проверить значение переменной QueryArg `region` на принадлежность множеству {197, 21, 54, 63, 43, 22, 64, 62, 213, 65, 66, 48, 50, 18, 51, 2, 67, 172, 16}.

Ниже приведен код, позволяющий выполнить эту задачу с использованием метода [set_state_by_key](../appendices/block-mist-methods.md#set_state_by_key).

Создается множество пар {key=value}: {197=197, 21=21, 54=54, 63=63, 43=43, 22=22, 64=64, 62=62, 213=213, 65=65, 66=66, 48=48, 50=50, 18=18, 51=51, 2=2, 67=67, 172=172, 16=16}.

В получившемся множестве среди ключей производится поиск значения QueryArg `region`.

Если такое значение найдено, поиск прекращается и найденное значение записывается в переменную `region` контейнера State.

Если значение не найдено, в переменную `region` контейнера State записывается значение по умолчанию 213.

```
<!-- Проверка переменной QueryArg region на принадлежность множеству {197,21,54,63,43,22,64,62,213,65,66,48,50,18,51,2,67,172,16} -->
<mist method="set_state_by_key">
    <param type="String">region</param>
    <param type="String">197,21,54,63,43,22,64,62,213,65,66,48,50,18,51,2,67,172,16</param>
    <param type="String">197,21,54,63,43,22,64,62,213,65,66,48,50,18,51,2,67,172,16</param>
    <param type="QueryArg" as="String">region</param>
</mist>

<!-- Если значение в множестве не найдено, используем значение по умолчанию 213. -->
<mist method="set_state_long" guard-not="region">
    <param type="String">region</param>
    <param type="Long">213</param>
</mist>
```

### Узнайте больше {#learn-more}
* [Mist-блок](../concepts/block-mist-ov.md)
* [Методы Mist-блока](../appendices/block-mist-methods.md)