# Как создать веб-страницу с использованием XScript

Для того чтобы создать веб-страницу с использованием XScript, необходимо выполнить следующие действия:

1. Перед созданием веб-страницы определите, какие CORBA-компоненты и HTTP-сервера будут генерировать динамический контент.
    
1. Создайте новый XML-файл, отвечающий требованиям, описанным в [соответствующем разделе](../concepts/xscript-file-ov.md). Корневым элементом рекомендуется сделать `page`. В теге [\<xscript\>](../reference/xscript.md) укажите параметры обработки файла.
    
1. Определите, какая функциональность должна выполняться при обработке веб-страницы и добавьте [XScript-блоки](../concepts/block-ov.md), реализующие эту функциональность.
    
1. Добавьте статические теги. Например, если в файле присутствует группа блоков, выполняющих функциональность по авторизации пользователя, можно обернуть эту группу тегом `<userinfo>`.
    
1. Подключите необходимые XSL-преобразования на уровне блока с помощью атрибута [xslt](../appendices/attrs-ov.md#xslt) или на уровне файла:
 
```xml
<?xml-stylesheet href="xsl/task.xsl" type="text/xsl"?>
```    

### Узнайте больше {#learn-more}
* [XML-файл на XScript](../concepts/xscript-file-ov.md)
* [Пример XML-файла на XScript](../appendices/example-page.md)
* [Понятие XScript-блока и его типы](../concepts/per-block-transformation-ov.md)
* [Перблочное XSL-преобразование](../concepts/per-block-transformation-ov.md)
* [Основное XSL-преобразование](../concepts/general-transformation-ov.md)
* [Как создать XScript-блок нового типа](../tasks/how-to-create-new-block.md)