# Как передать данные между блоками или CORBA-компонентами

Существует два способа передачи данных между блоками или CORBA-компонентами, причем первый способ может использоваться для передачи данных и между блоками, и между CORBA-компонентами, а второй - только между CORBA-компонентами. Оба эти способа описаны ниже.

1. В первом случае передача данных производится с использованием [XPath](../reference/xpath.md)-выражения, которое сохраняет в [State](../concepts/state-ov.md) извлеченное из результата работы блока значение. Чтобы передать данные, необходимо:

	1. С помощью XPath извлечь данные из результатов работы блока. Например:

		```
		<http threaded="no" timeout="3000">
    		<method>getHttp</method>
    		<param type="StateArg" as="String">search_editions_url</param>
    		<xpath expr="/library/editions/edition/@id" result="edition_ids" delim=","/>
		</http>
		```

	1. 	Передать данные в другой блок или CORBA-компонент с помощью параметра типа StateArg. Например:
		```
		<block threaded="no" timeout="3000">
		    <guard>edition_ids</guard>
		    <name>Yandex/Books/Card.id</name>
		    <method>getCards</method>
		    <param type="String">microcard</param>
		    <param type="StateArg" as="String">edition_ids</param>
		    <param type="String">,</param>
		    <param type="String">editions</param>
		</block>
		```
    
1. Во втором случае передача данных между CORBA-компонентами производится через контейнер [State](../concepts/state-ov.md). Чтобы передать данные от одного CORBA-компонента другому, выполните следующие действия:
    
    1. Обеспечьте добавление в контейнер State передаваемых данных. Для этого:
		1. Добавьте в передающий данные CORBA-компонент метод, которому передаётся параметр типа [State](../concepts/parameters-complex-ov.md). Этот метод должен уметь выкладывать в контейнер State свои данные:

			```
			state->setParam(name, any);
			```
		
			**Совет**: добавлять данные в контейнер можно также локально, без обращения к CORBA - с помощью [Mist-блоков](../concepts/block-mist-ov.md).
		1. Добавьте в XML-файл XScript-блок, вызывающий этот метод.

	1. Обеспечьте извлечение из контейнера данных. Для этого:
		1. Добавьте в принимающий данные CORBA-компонент метод, которому передаётся параметр типа State. Этот метод должен уметь извлекать данные:
			```
			state->getParam(name);
			```
		1. Добавьте в XML-файл XScript-блок, вызывающий этот метод.


В результате выполнения действий будет выполнена передача данных между блоками или CORBA-компонентами.

Если в XML-файле есть передача данных между компонентами, необходимо внимательно следить за правильным порядком исполнения XScript-блоков, чтобы избежать ситуации, когда принимающий данные метод начнёт выполняться до окончания работы передающего. Поэтому особенно осторожно используйте асинхронную обработку блоков.

{% note info %}

Рекомендуется использовать первый способ передачи данных (XPath+StateArg), так как передача данных через State менее эффективна из-за дополнительной нагрузки на сеть, возникающей в результате обратных вызовов.

{% endnote %}

### Узнайте больше {#learn-more}
* [CORBA-блок](../concepts/block-corba-ov.md)
* [Методы Mist-блока](../appendices/block-mist-methods.md)