# Report renderer и apphost

- [Видео](https://cipt-cms-storage2.yndx.net/recs/spaces/a14a7646-998b-4d08-b6fd-3159885fa814/20210220140558+0300.mp4) с рассказом
- [Документация](https://doc.yandex-team.ru/apphost/pages/why_me.html)

Ниже краткое изложение того, что в видео.

Для понимания простая схема:
![text](../_assets/rr.png "Report renderer" =550x250)

Апхост обрабатывает запросы в соответствии с прописанным конфигом. Конфиг представляет собой ориентированный граф, узлами которого являются источники. Источник принимает запрос, ходит в БД/пишет в БД и тд. Результат работы источник добавляет в контекст.
В апхосте есть своя логика балансировки нагрузки.

![text](../_assets/apphost.png "Graph" =550x550)

* **Templates** - специальный источник, он не кладет ничего в контекст, а возвращает тот результат, что вернется в браузер (json, html). Это всегда последняя вершина. По сути это нода, внутри которой запущен RR.
* **RR** - скрипт на ноде, слушает 80-тый порт, принимает запросы пользователя + контекст и возвращает строку. Конфиг RR - это путь до файла, где лежит код шаблонов (`/build/renderer.js`). В услугах точка входа в серверный код `report-renderer/index.ts`. По факту RR внутри рекваирит renderer.js и вызывает внутри функцию main, передавая аргументом контекст.

## Что с аяксом?
Пример: запросы вида `/uslugi/api/get_workers`
Все флоу такое же до шага про `renderer.js`. Внутри `renderer.js` если пришел такой запрос, то отдаем не html, а часть стейта через JSON.stringify
Из `renderer.js` нельзя делать асинхронные запросы - RR обрабатывает только синхронные запросы. (по факту на main нет await)

## Kotik/Templar

Это dev-сервер для локальной разработки. Умеет работать с `renderer.js` и шаблонами. Запросы локально идут через kotik, у которого есть конфиг.
Запросы вида `/uslugi/*` за данными по факту ходят в прод с параметром `renderer_export=json`. Для RR этот параметр говорит о том, что не надо выполнять шаблоны, а надо просто вернуть содержание контекста как JSON. Т.е при наличии такого параметра не запускается `renderer.js` и не формируется html.
Kotik локально запускает RR и вызывает внутри функцию main, передавая аргументом контекст, который вернулся из запроса (по факту запроса в прод)

Templar - примерно то же самое, что и kotik, просто устаревшая версия
