# Загрузка картинок (картинатор)

## Загрузка картинок в аватарницу

[Форма для загрузки картинок](https://ydo-admin-dev.yandex-team.ru/uslugi-admin/imaginator).

Данная форма предназначена для загрузки изображения в аватарницу ([подробнее об аватарнице](https://wiki.yandex-team.ru/mds/avatars/)).
Загружать изображения желательно в самом большом разрешении, чтобы изображение было четким ,
сжатие и ресайз произойдет на стороне аватарницы.

{% note warning %}

Если у вас есть изображение в разрешении x1, x2 и x3, то достаточно загрузить только x3.

{% endnote %}

{% note info %}

Если у вас есть изображение в разрешении x1, x2 и x3, можно увеличить плотность пикселей на изображении. Данное значение будет учтено во время кропа через форму и сохранено для дальнейшего переиспользования.

{% endnote %}

После загрузки изображения в браузер, в форме выведется оригинал изображения в исходном разрешении.

{% note warning %}

Пожалуйста, не игнорируйте предупреждения о размере и весе изображения.

{% endnote %}

{% note info %}

Кнопка "Resize" позволяет уменьшить размер изображения с сохранением пропорций, если оно слишком большое.

{% endnote %}

Если загруженное в браузер изображение вас устраивает и подходит под описанные выше условия (или вы
уверены, что условия можно нарушить), то загрузить изображение в аватарницу можно нажатием на
кнопку "Загрузить в аватарницу".

После загрузки ниже будет отображена ссылка на аватарницу без пресета,
оптимизированный оригинал и изображения в различных пресетах. Про использование картинок из аватарницы можно прочесть в разделах
"Использование картинок картинатора внутри лендингов" и "Использование картинок картинотора в других блоках".

{% note tip %}

Чтобы скопировать ссылку, можно нажать на иконку копирования, чтобы не выделять всю ссылку.

{% endnote %}

{% note tip %}

Можно использовать компонент `UploadImageModal` или `ImageField` в админке для загрузки фото в случайном месте, чтобы не ходить на отдельную страницу.

{% endnote %}

## Кроп изображений

Картинатор позволяет не только загрузить изображение, но и кропнуть его. В кропалке уже забиты основные пресеты, которые используются в СМ. Если набор пресетов не подходит, можно в инпуте ввести нужный размер кропа.

{% note warning %}

Размер кропа зависит не только от выбраного размера, но и плотности пикселей. Если размер кропа равен 400х400 и плотность пикселей составляет х2, то после кропа итоговое изображение будет размера 800х800.

{% endnote %}

## Использование картинок картинатора внутри лендингов

Для лендинга можно использовать либо ссылку на оптимизированный оригинал (пресет `/optimize`) , либо ссылку на аватарницу без пресета с указанием размера картинки, если нужна адаптивная картинка.

Пример использования конфига блока лендинга со ссылкой на оптимизированный оригинал:
```json5
{
    ...,
    "blockMeta": {
        ...,
        "background": {
            "imageUrl": "https://avatars.mds.yandex.net/get-ydo_frontend/6287309/2a00000181ce4534b6bd6e87c009fdd1a6b8/optimize"
            "imageUrlTouch": "https://avatars.mds.yandex.net/get-ydo_frontend/5403800/2a00000181ce456ed3628911e51dd64a4f84/optimize"
        },
    }
}
```

Пример использования конфига блока лендинга со ссылкой на аватарницу без пресета:
```json5
{
    ...,
    "blockMeta": {
        ...,
        "background": {
            "imageUrl": {
                "url": "https://avatars.mds.yandex.net/get-ydo_frontend/6287309/2a00000181ce4534b6bd6e87c009fdd1a6b8",
                "size": "x2"
            },
            "imageUrlTouch": {
                "url": "https://avatars.mds.yandex.net/get-ydo_frontend/5403800/2a00000181ce456ed3628911e51dd64a4f84",
                "size": "x2"
            }
        },
    }
}
```

Блоки, которые поддерживают адаптивные картинки в аватарнице:
* blockMeta, в котором указывается ссылка на задний фон блока

## Использование картинок картинотора в других блоках

Для использования картинок в произвольном месте вы можете воспользоваться ссылкой на оптимизированный оригинал, если вам не нужна адаптивная картинка.

Если вам нужная адаптивная картинка, можно использовать ссылку на аватарнице в следующем виде:
```json5
{
    "url": "https://avatars.mds.yandex.net/get-ydo_frontend/5403800/2a00000181ce456ed3628911e51dd64a4f84",
    "size": "x3"
}
```

{% note tip %}

Чтобы из объекта представленного выше объекта получить srcSet для изображения можно воспользоваться функцией `buildImaginatorUrl`. После полученный srcSet можно передать в тег `img` или компонент `Thumb`.

{% endnote %}

{% note tip %}

Если адаптивное изображение нужно использовать в виде заднего фона, можно воспользоваться функцией `buildBackgroundImaginatorUrl`. После полученную строку можно передать в качестве значения `backgroundImage` в стилевых пропсах.

{% endnote %}

## Настройка бакета в аватарнице

[Ссылка на конфиг бакета](https://mds.yandex-team.ru/avatars/namespaces/ydo_frontend/overview)

[Документация по неймспеснице](https://wiki.yandex-team.ru/mds/avatars/nscfg/)
