# Критерии подготовки задачи

## Для штырилки
1. У задачи есть описание, в котором чётко сформулировано что надо сделать и для чего
2. В задаче указано кто заказчик/ответственный менеджер
3. Требуется ли дизайн ревью?
4. Если задача влечёт за собой визуальные изменения, то должна быть ссылка на макеты, в которых отражено что именно и как должно выглядеть
5. В задаче должны быть указаны необходимые компоненты:
	1. Функциональный: например  `Frontend`
	2. Команда: например `NRGroup`
	3. И другие, если необходимо
6. В описании указана платформа(ы) для которых нужны изменения:
	1. `Desktop`
	2. `Touch`
7. Указано должны ли изменения быть закрыты флагом
8. Задача должна быть оформлена согласно шаблону (код, ссылки, цитаты и т.д.)

## Для взятия на оценку
1. Задача прошла штырилку в команде
2. В задаче должны быть указаны необходимые технические детали: название флага, ссылки на документацию, строки кода, wiki и т.д., если они необходимы для выполнения задачи

## Для взятия в спринт
У задачи должна быть:
1. Выставлена оценка в SP
2. Если задача зависит от бэкенда и/или других систем, то задачи на изменения в этих системах должны быть прилинкованы в зависимостях. В прилинкованных задачах на бекенд должен быть явно указан контракт на получение / отправку данных
3. В макетах (или описании задачи) должны быть финальные тексты
4. Если у задачи есть явный дедлайн, то он должен быть указан в тикете. Дедлайн должен быть обоснован. Хорошо: нам нужна задача к дате X потому, что мы её будем показывать на внешнем мероприятии. Плохо: дедлайн обосновывается только желанием менеджера / данными кому-то обещаниями.

## Для передачи в code review
1. Прочитать свой код в Arcanume (self review)
2. Если в коде есть изменения, которым нужно уделить больше внимания на ревью, то рядом с ними следует оставить поясняющий комментарий
3. Проверить, что бета работает (задача Deploy в CI завершилась успешно). Распространённая причина почему бета не собралась — ошибки типов. Можно заблаговременно проверить, запустив `npm run typecheck` в папке проекта.
4. Убедиться, что нет упавших тестов в CI. Если есть упавшие тесты, то только такие, падение которых было ожидаемым (например, внесены визуалные изменения и требуется переснятие эталонов).

## Для передачи в тестирование
1. Написать нужные автотесты для задачи, если что-то нельзя автоматизировать, записать как ручной сценарий
2. Протестировать изменения на бете по основным требованиям/сценариям, исправить баги
3. Разработчик должен написать в комментарии тест-план, который отвечает на вопросы:
	1. Что добавилось/поменялось?
	2. Какие части проекта задеты изменениями?
	3. Какие дополнительные (неочевидные) сценарии/части проекта  рекомендуешь проверить?
