# Hermione
[Документация](https://wiki.yandex-team.ru/ydo/frontend/hermione/) по написанию Hermione-тестов

# Гермиона в PR

Бывает, что в PR падает тест, который не относится к вашим правкам, или падают рандомные тесты
В таком случае надо проверить стабильность теста в [тесткопе](https://testcop.si.yandex-team.ru/)

### Testcop

В тесткопе можно проверить стабильность теста, посмотреть заскипан он или нет, в каких браузерах тест заскипан и узнать кто заскипал тест. Перед этим надо выбрать проект (`Ydo`).

### Как заскипать тест

Сделать это можно в самой таске гермионы в PR, внутри есть таска ydo-testkop внутри которой будут указаны упавшие тесты

### Как расскипать тест

При заскипывании тест автоматически создается задача на расскип, поэтому расскапывать тест нужно через эту задачу.
Для этого надо изменить тест так, чтобы он стал стабильным. Локально его можно прогонять с помощью переменной окружения [ISSUE_KEYS](https://doc.yandex-team.ru/si-infra/tests-stability/testcop/testcop-how-to-unskip-or-unmute-test.html#kak-ubeditsia-chto-test-stabilen).

```bash
ISSUE_KEYS='YDO-2522,YDO-5345' npm run hermione:local
```
После того, как PR вольется тест автоматически расскипается.

### Как быстро переснять скриншоты hermione тестов, упавших в ci
Если у вас в CI-проверке `Hermione large` валидно упали скриншоты и нужно их пачкой переснять, то делаем так:
1. Добываем ссылку на отчет. [Шаг 1](https://wiki.yandex-team.ru/ydo/newstaff/.files/snimokjekrana2021-02-18v10.51.00.png) => [Шаг 2](https://wiki.yandex-team.ru/ydo/newstaff/.files/snimokjekrana2021-02-18v10.51.27.png)
2. Чекаутимся на нужную ветку и запускаем локально гермиону с нужным шаблоном
```bash
npm run hermione:gui -- --from https://proxy.sandbox.yandex-team.ru/1997718449/index.html
```
Последний аргумент это ссылка из пункта 1
3. Когда на localhost откроется нужный отчет, проверяем что это то, что было в ci, жмем в шапке фильтр `Expand Errors` и выбираем `Accept Opened` [Пример](https://wiki.yandex-team.ru/ydo/newstaff/.files/snimokjekrana2021-02-18v11.05.29.png). Если вы хотите выборочно переснять скриншоты, то можно точечно на конкретном скриншоте нажать [Accept](https://wiki.yandex-team.ru/ydo/newstaff/.files/snimokjekrana2021-02-18v11.12.32.png)

### Как измененить таймаут выполнения теста
Некоторые тесты могут быть нестабильными по причине нехватки дампов запросов. Такое может происходить из-за быстрого прокликивания форм при прогоне теста в режиме `create`. Это приводит к отмене или пропуску некоторых запросов на бэкенд, которые все-же могут потребоваться в режиме `play`.

Одним из выходов из такой ситуации является временная установка длительных пауз после каждого клика, чтобы сохранить максимально возможное количество дампов запросов. В таком случае дефолтного таймаута в 60 секунд может не хватить. Что бы его повысить, необходимо в файле [`hermione.conf.js`](https://a.yandex-team.ru/arcadia/frontend/services/ydo/.config/hermione/hermione.conf.js) установить таймаут в поле `config.system.mochaOpts.timeout`. Он задается в миллисекундах.

Не следует забывать, что после успешного снятия дампов требуется удалить лишние паузы и вернуть значение таймаута к дефолтным настройкам.
