## Введение
**Партнёрский кабинет** (ERP) - это сервис, с помощью которого партнёры Яндекс Услуг, работающие по [сервисной модели](https://wiki.yandex-team.ru/ydo/service-model), управляют:
- заказами (подтверждают, изменяют, отменяют)
- сотрудниками (управляют расписанием, переназначают с заказов, отключают и увольняют)
- балансом (пополняют и отслеживают)
- услугами (назначают цены, время, оплату)

Помимо основного функционала кабинета, он так же предоставляет дополнительные возможности для ведения бизнеса - отчёты, графики расписаний сотрудников, метрики качества, группы исполнителей, зоны выезда и зоны работы сотрудников, кастомизация интерфейса под конкретные категории и тд.

{% note info %}

Не путать с "админкой партнёра" - это отдельная [страница](https://ydo-admin-dev.yandex-team.ru/uslugi-admin/order-partner) в [админке](https://docs.yandex-team.ru/ydo/ydo-admin/), через которую тех поддержка управляет партнёрской организацией.

{% endnote %}

## Доступы
Доступ к кабинету имеют только работники зарегистрированной организации партнёра. Внутри они делятся по ролям (владелец, администратор, менеджер). Для того, чтобы получить доступ к кабинету необходимо зайти под одним из таких аккаунтов, либо залогинившись, либо из-под puid-a.

Удобнее всего пользоваться тестовым аккаунтом супер-менеджера - yndx-ydo-partner-admin-1/te$tY%do (puid=1521594961)

{% note warning %}

Мутирующие запросы (POST, UPDATE, DELETE) не доступны из-под puid-a. Так же в зависимости от роли пользователя, доступ к некоторым из таких запросов может быть закрыт.

{% endnote %}

## Стенды
### Прод
- Ссылка - [uslugi.yandex.ru/erp](https://uslugi.yandex.ru/erp)
- Обновляется при выкатке релиза
- Смотрит в продовую базу данных

### Тестинг
Все стенды смотрят в тестовую базу данных
1. Мастер
    - Ссылка - [renderer-ydo-erp-dev-master.hamster.yandex.ru/uslugi/erp](https://renderer-ydo-erp-dev-master.hamster.yandex.ru/uslugi/erp)
    - Обновляется на каждое изменение в транке
2. Шаред
    - Ссылка - [shared-dev.hamster.yandex.ru/uslugi/erp](https://shared-dev.hamster.yandex.ru/uslugi/erp)
    - Обновляется при подготовке к очереднему релизу
    - Используется тестировщиками для регресса релиза
3. Бета пулл-реквеста (PR)
    - Ссылка - [renderer-ydo-erp-pull-<PR_NUMBER>.hamster.yandex.ru/uslugi/erp/](https://renderer-ydo-erp-pull-<PR_NUMBER>.hamster.yandex.ru/uslugi/erp/)
    - Обновляется в процессе работы джобы Deploy (запускается на каждый пуш в PR)
    - Используется для тестирования новых изменений, внесённых разработчиком
    - Ссылка подкладывается в тикет и в PR

### Локальная бета
- Ссылка - [local.yandex.ru:3443/uslugi/erp](https://local.yandex.ru:3443/uslugi/erp)
- Смотрит в тестовую базу данных
- Обновляется при пересборке вебпака

{% note tip %}

Подменять шаблоны/бекенд, смотреть в эксперименты можно через query-параметры:
- `test-id` - идентификатор экспериментальной выборки
- `srcrwr` - идентификатор источника данных

{% endnote %}

## Сущность "Услуга", "Рубрикатор", "Допка"
См. [Документация бека](https://wiki.yandex-team.ru/users/diplay/erp/#opredstavleniirubrikvslotaxzakazaxiprajjs-liste)

### Глоссарий
* **Специальность** - общее направление работы компании. В рамках MVP завязываемся на 1 специальность у компании. Например, ремонт бытовой техники.
* **Группа** - группа услуг. Например, техники bosh.
* **Услуга** - зонтик для конкретных услуг. Нельзя назвать точную сумму, но чаще всего клиент не может сказать точнее. Например, ремонт стиральных машин bosh.
* **Конкретная услуга** - четко определенное регламентом действие. Можно назвать точную цену и длительность. Например, замена шланга в стиральных машин bosh.
* **Допники** - действия или материалы, которые можно сделать только вместе с конкретной услугой. Например, шланг для замены.
* **Рубрикатор** - дерево, в котором описаны все специальности, группы, услуги и допники и отражена их иерархия. Не привязан к организации. Настраивается и хранится в бекенде YDO. Используется там для уточнения у заказчика проблемы.

### Уровни рубрикатора
* Специальность
* Группы. Их много и они вложены друг в друга. Детьми группы могут быть либо другие группы либо услуги, но не то и другое одновременно
* Услуга рубрикатора aka "общая услуга"
* Варианты оказания услуги (услуга рубритора + выбранный набор фич) или "услуга + фичи" или "листья дерева рубрикатора" или "конкретная услуга"
* Допники (доп. услуги или материалы)

### Как устроено на бекенде
Полный список услуг хранится в рубрикаторе. В базе хранится список услуг, привязанных к конкретной организации.
На беке сложно синхронизировать изменения в рубрикаторе если заводить каждую услугу сразу как она появляется в рубрикаторе.
Считаем, что организация подтверждает лишь небольшую часть всего прайса и хранить все остальные услуги избыточно.
При добавлении новой услуги или регистрации компании в базе не создается привязанных к организации услуг.
`/get_services_organizations` сливает рубрикатор с созданными услугами и отдает на фронт.
Если услуга или допка не было привязана к организации, то есть в базе нет записи `org->service`, то данные по такой услуги будут приходить неполные: в ответе будет отсутствовать `id, price, duration, enabled`.
> Признак отсутствия записи услуга-организация это пустое поле `id`

Вытекающие ограничения:
* Нельзя редактировать несозданную услугу. Для редактирования ее нужно сначала создать
* Нельзя создать допку к несозданной услуге
* Если услуга выключена, то допка не может быть включена или отредактирована
* Пока идет запрос на переключение родительской услуги нельзя переключать допку
* Пока идет запрос на допку нельзя переключать родительскую услугу,
* Так как мы мутируем данные при блюре, то нельзя отправлять сразу несколько запросов по одной и той же допке или услуге

p.s. переключение - включение или отключение

## Ссылки
[Задачи](https://wiki.yandex-team.ru/ydo/service/partners/#zadachidljarazrabotkiv6)

[Макеты](https://www.figma.com/file/srGq29ceDO7pa90kSEhpys/Исполнительский-сервис)

[Разработчики фронтенда erp](https://idm.yandex-team.ru/system/abc/roles#f-role=abc/services/meta_experiments/ydo/ydo_frontend/*/6575,f-ownership=personal,f-status=all,sort-by=-updated)
