# Дизайн система

[Ссылка на фигму](https://www.figma.com/file/LCpK24ND8J4EcaKNVhZmDY/Карл-Маркс)

Все цветовые константы и иконки лежат в директории `src/design-system`.

{% note warning %}

Внесение изменений в директорию `design-system` необходимо согласовывать с дизайнерами и согласно нашей [фигме](https://www.figma.com/file/LCpK24ND8J4EcaKNVhZmDY/Карл-Маркс).

{% endnote %}

{% note warning %}

На ревью изменений внутри директории `design-system` призываются дизайнеры, от которых нужно получать ОК на внесение изменений.

{% endnote %}

{% note tip %}

Можно скидывать ПР дизайнеру в личку ссылкой на изменения в `design-system`, чтобы ускорить согласование.

{% endnote %}

## Цвета

Использовать цвета не из констант в коде сервиса запрещено, разрешены только цвета из `~design-system/ui-kit2/constants/colors.pcss`.

{% note warning %}

Если нужного вам цвета нет в константах, но он есть в фигме, то нужно добавить его в дизайн систему и согласовать внесение изменений с дизайнерами.

{% endnote %}

{% note warning %}

Если нужного вам цвета нет в [цветах фигмы](https://www.figma.com/file/LCpK24ND8J4EcaKNVhZmDY/Карл-Маркс?node-id=1901%3A11315), то сперва дизайнеру нужно добавить нужный для задачи цвет в фигму,
а после уже разработчику добавить этот цвет в `design-system`.

{% endnote %}

## Иконки

Использовать цвета не из `design-system` в коде сервиса запрещено, разрешены только иконки из `~design-system/ui-kit2/icons`.

{% note warning %}

Если нужной вам иконки нет в коде, но она есть в фигме, то нужно добавить иконку в дизайн систему и согласовать внесение изменений с дизайнерами.

{% endnote %}

{% note warning %}

Если нужной вам иконки нет в [фигме](https://www.figma.com/file/LCpK24ND8J4EcaKNVhZmDY/Карл-Маркс?node-id=11621%3A41097), то сперва дизайнеру нужно добавить нужную для задачи иконку в фигму,
а после уже разработчику добавить эту иконку в `design-system`.

{% endnote %}
