### Loadable

Loadable представляет собой HOC, который позволяет загружать код компонента только в том случае, если он рендерится на странице (во време SSR компонент тоже отрендерится и весь код загрузится перед гидрацией).
Виды loadable:
* default import из `@loadable/component` (не содержит fallback)
* loadable в нашем коде (в качестве fallback используется Loader)


### DelayLoadable

HOC `withDelayLoadable` позволяет загрузить код модуля и отрендерить компонент только на клиенте. Такой подход позволяет сократить размер кода, который изначально загружается на клиенте, но компонент будет без SSR. В последущих SPA-переходах `withDelayLoadable` работает аналогично loadable.

### LazySaga

Cаги желательно подключать через withLazySaga, чтобы код самих саг не попадал в общий бандл. Напрямую стоит только подключать те саги, которые ловят экшены на всех страницах с самого старта, все остальные лучше загружать отложено. Если у вас есть фича, которая сразу вызывает сагу на определенной странице на старте, можно загрузить ее через then динамического импорта, но в большинстве случае функционал не деградирует с ленивой сагой.

Все саги фичи можно убрать в один модуль и загружать их все лениво при обращении к одной, либо разбить на логические модули разбить, чтобы подгружать только необходимый минимум, но в таком случае будет больше отдельных модулей (динамические модули преобразовываются в приличный кусок кода). В большинстве случаев достаточно все саги сложить в один модуль, только если часть саг не используется в нескольких модулях.
