# Структура проекта

* src/adapters - отвечает за маппинга ответа бека в ответ, который ожидает верстка (исполняются на сервере)
* src/api - набор методов для похода в бек, хендлинг ошибок
* src/assets - набор статичных файлов и шаблонов для генерации ответа сервера
* src/components(deprecated) - все компоненты, которые были созданы до разбиение кода по фичам
* src/constants - общие на весь проект константы
* src/core - пока тут лежит только di
* src/data-transformers - маппинг данных для отправки на бек
* src/design-system - иконки, цвета и другие константы из нашей [дизайн системы](https://www.figma.com/file/LCpK24ND8J4EcaKNVhZmDY/Карл-Маркс)
* src/features - дирректория с фичами сервиса
    * src/features/ui-kit/(deprecated) - старый ui-kit
    * src/features/ui-kit2 - новый ui-kit, но не весь функционал еще реализован
* src/hocs - общие на весь проект HOCs
* src/hooks - общие на весь проект хуки
* src/mocks - моки для юнитов
* src/models - интерфейсы бизнесовых моделек
* src/pages - базовый класс Page и часть страниц сервиса
* src/proto-schemas - тайпинги для карты
* src/report-renderer - описание тайпингов бека, api-router и функции для шаблонизации и генерации ответа сервера
* src/resources - обработка внешних ресурсов
* src/router - описание роутов и инициализация роутера
* src/seo - утилиты для seo
* src/service-worker - код для работы sw
* src/services - сервисы для работы с mobapp api
* src/store - часть слайсов сторы и инициализация сторы
* src/stubs - набор тулов для стаба ответов бека во время dev-разработки
* src/styles - общие стили, константы и миксины
* src/typings - общие тайпинги
* src/utils - все оставшееся)

* .config/appConfig - общие конфиги приложения
* tools - набор тулов для работы с дампами, сборки и т.п.
* tests - интеграционные тесты на гермионе и хелперы для сторибука

### Файлы на много строк с большим количеством функций (саги, селекторы и др.)

Следует избегать появления файлов с большим количеством строк на много модулей, т.к. в таких случает распиливание бандла происходит значительно хуже.

Следует складывать все функции в отдельные файл внутри директории (для селекторов директория будет selectors) как можно ближе к месту использования. Если селектор используется в одном компоненте, то лучше складывать его рядом с компонентом, а не тащить в стору. А если селектор нужен в нескольких компонентах, то складывать его в отдельный файл в нужном слайсе сторы в директории selectors. Подробнее можно почитать [тут](https://yndx-uslugi.slack.com/archives/G01EGMM9RV0/p1639989003006200).
