# Кодогенерация

Для упрощения создания новых сущностей, чтобы не создавать все файлы, функции, интерфейсы вручную, можно воспользоваться специальными командами, которые сгенерируют этот шаблонный код за вас.

На текущий момент доступна генерация новых:
* компонентов
* страниц (компоненты, отнаследованные от `Page`)
* модальных окон (компоненты, отнаследованные от `BaseModal`)

Для генерации компонента выполните команду:

```bash
$ npm run plop component
```
или

```bash
$ npm run plop component MyComponentName
```

чтобы пропустить вопрос об имени компонента.

Скрипт проверит существование компонента с таким именем во всех директориях с компонентами и страницами, и если оно не занято, то задаст уточняющие вопросы. В результате вы получите директорию с уже готовым компонентом.

Для генерации страниц и модальных окон необходимо воспользоваться командами:

```bash
$ npm run plop page
$ npm run plop modal
```

## Реализация

Генерация кода реализована с помощью фреймворка [Plop.js](https://plopjs.com/), в основе которого лежат [Inquirer.js](https://github.com/SBoudrias/Inquirer.js) для задания вопросов и [Handlebars.js](https://handlebarsjs.com/) для шаблонов.

## Дополнения и улучшения

Вы можете самостоятельно вносить изменения — весь код отвечающий за кодогенерацию лежит в директории [src/plop](https://a.yandex-team.ru/arc_vcs/frontend/services/ydo/src/plop). Точка входа — [plopfile](https://a.yandex-team.ru/arc_vcs/frontend/services/ydo/src/plop/plopfile.js).

Идеи и предложения можно оставлять в [эпик-задаче](https://st.yandex-team.ru/YDO-38086).
