import io
import base64
import h5py
import json
import numpy as np
from argparse import ArgumentParser
from library.python import resource
from tensorflow import keras
from PIL import Image


def parse_image(data):
    img = Image.open(io.BytesIO(base64.b64decode(data)))
    return np.array(img.resize((150, 80)))


def main():
    cmd = ArgumentParser()
    cmd.add_argument("--base64", nargs="+", help="Image to decode")
    args = cmd.parse_args()
    model_h5 = io.BytesIO(resource.find("model_90.h5"))
    with h5py.File(model_h5, "r") as h5_file:
        model = keras.models.load_model(h5_file)
    X = np.array(list(map(parse_image, args.base64)))
    y = model.predict(X)
    print(json.dumps(list(map(lambda v: "".join(map(str, v)), np.argmax(y, axis=2)))))


if __name__ == "__main__":
    main()
