package main

import (
	"os"

	"a.yandex-team.ru/drive/analytics/gotasks"
	"a.yandex-team.ru/yt/go/mapreduce"

	// Database drivers.
	_ "github.com/ClickHouse/clickhouse-go"
	_ "github.com/jackc/pgx/v4/stdlib"
	_ "github.com/mattn/go-sqlite3"

	// Commands.
	_ "a.yandex-team.ru/drive/analytics/gotasks/aggression"
	_ "a.yandex-team.ru/drive/analytics/gotasks/cars"
	_ "a.yandex-team.ru/drive/analytics/gotasks/data"
	_ "a.yandex-team.ru/drive/analytics/gotasks/exports"
	_ "a.yandex-team.ru/drive/analytics/gotasks/fuelings"
	_ "a.yandex-team.ru/drive/analytics/gotasks/runsql"
	_ "a.yandex-team.ru/drive/analytics/gotasks/service"
	_ "a.yandex-team.ru/drive/analytics/gotasks/sessions"
	_ "a.yandex-team.ru/drive/analytics/gotasks/taxidwh"
	_ "a.yandex-team.ru/drive/analytics/gotasks/tracks"
	_ "a.yandex-team.ru/drive/analytics/gotasks/users"
)

func main() {
	// Handle that we are running inside MapReduce job.
	if mapreduce.InsideJob() {
		os.Exit(mapreduce.JobMain())
	}
	if err := gotasks.RootCmd.Execute(); err != nil {
		panic(err)
	}
}
