CREATE TABLE production.compiled_rides
(
    `session_id` String,
    `user_id` String,
    `object_id` String,
    `offer_type` String,
    `offer_name` String,
    `offer_group_name` String,
    `insurance_type` String,
    `entry_to_eco_zones_in_germany` Int8,
    `snow_chains` Int8,
    `gps` Int8,
    `roof_rack` Int8,
    `child_seat` Int8,
    `offer_timestamp` Int64,
    `offer_deadline` Int64,
    `total` Int64,
    `currency` String,
    `total_payment` UInt64,
    `status` String,
    `deposit` UInt64,
    `standard_parking_price` UInt32,
    `standard_riding_price` UInt32,
    `pack_price` UInt32,
    `start_timestamp` Int64,
    `finish_timestamp` Int64,
    `start_latitude` Float64,
    `start_longitude` Float64,
    `finish_latitude` Float64,
    `finish_longitude` Float64,
    `mileage` Float64,
    `finished` Int8,
    `useless_duration` UInt32,
    `riding_timestamp` Int64,
    `acceptance_duration` UInt32,
    `riding_duration` UInt32,
    `parking_duration` UInt32
)
ENGINE = ReplicatedReplacingMergeTree('/clickhouse/tables/{shard}/production.compiled_rides', '{replica}')
PARTITION BY toYYYYMMDD(toDateTime(finish_timestamp))
ORDER BY (object_id, session_id)
SETTINGS index_granularity = 8192;
