CREATE TABLE "yt_hahn_carsharing_stats" ON CLUSTER '{cluster}' (
    "time" Int64,
    "path" String,
    "disk_space" Int64,
    "chunk_count" Int64,
    "node_count" Int64
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/production.yt_hahn_carsharing_stats', '{replica}')
ORDER BY ("path", "time")
PARTITION BY toYYYYMMDD(toDateTime("time"))
TTL toDateTime("time") + INTERVAL 10 DAY;
