import openpyxl
from re import sub
import yt.wrapper as yt

from .excel_validate import StartDocument


class CheckDecreeDocument(StartDocument):
    @classmethod
    def get_name(cls):
        return 'check_decree'

    @classmethod
    def get_scheme(cls):
        return None

    @classmethod
    def get_yt_list(cls):
        yt.config.set_proxy('hahn')

        table_path = yt.TablePath('//home/carsharing/support/fines/export_ext', columns=['ruling_number'])
        column = yt.read_table(table_path)

        decree_list = []
        for row in column:
            decree_list.append(row['ruling_number'])

        return decree_list

    @classmethod
    def parse_document(cls, input_file, output_file, meta=None):
        xl_file = openpyxl.open(input_file, data_only=True)
        sheet = xl_file.active

        column_number = None
        for row in sheet.iter_rows(0, 1):
            for col in range(0, sheet.max_column):
                key = sub(r"\s", '_', str.strip(str(row[col].value)).upper())
                if key == 'DECREE':
                    column_number = col + 1
                continue

        if column_number is None:
            raise Exception('Column "decree" not found')

        excel_decree = []
        for col in sheet.iter_cols(column_number, column_number):
            for row in range(1, sheet.max_row):
                if col[row].value is not None:
                    excel_decree.append(sub(r'\s+', ' ', str.strip(str(col[row].value))))

        yt_decree = cls.get_yt_list()

        ex_set_decree = set(excel_decree)
        yt_set_decree = set(yt_decree)

        intersect = ex_set_decree.intersection(yt_set_decree)

        data = {}
        rows = []
        if len(intersect) > 0:
            for item in intersect:
                rows.append({item: ''})

            data['decree(s)'] = rows
            raise Exception(data)


class CheckDecreeYandexIndividulsDocument(StartDocument):
    @classmethod
    def get_name(cls):
        return 'check_decree_ya_indiv'

    @classmethod
    def get_scheme(cls):
        return None

    @classmethod
    def get_yt_list(cls):
        yt.config.set_proxy('hahn')

        table_path = yt.TablePath('//home/carsharing/testing/data/garage/yandex_indiv/2062_yandex_individuals.xlsx', columns=['decree'])
        column = yt.read_table(table_path)

        decree_list = []
        for row in column:
            decree_list.append(row['decree'])

        return decree_list

    @classmethod
    def parse_document(cls, input_file, output_file, meta=None):
        xl_file = openpyxl.open(input_file, data_only=True)
        sheet = xl_file.active

        column_number = None
        for row in sheet.iter_rows(0, 1):
            for col in range(0, sheet.max_column):
                key = sub(r"\s", '_', str.strip(str(row[col].value)).upper())
                if key == 'DECREE':
                    column_number = col + 1
                continue

        if column_number is None:
            raise Exception('Column "decree" not found')

        excel_decree = []
        for col in sheet.iter_cols(column_number, column_number):
            for row in range(1, sheet.max_row):
                if col[row].value is not None:
                    excel_decree.append(sub(r'\s+', ' ', str.strip(str(col[row].value))))

        yt_decree = cls.get_yt_list()

        ex_set_decree = set(excel_decree)
        yt_set_decree = set(yt_decree)

        intersect = ex_set_decree.intersection(yt_set_decree)

        data = {}
        rows = []
        if len(intersect) > 0:
            for item in intersect:
                rows.append({item: ''})

            data['decree(s)'] = rows
            raise Exception(data)
