import openpyxl
from re import sub
import yt.wrapper as yt

from .excel_validate import StartDocument


class CheckVINDocument(StartDocument):
    @classmethod
    def get_name(cls):
        return 'check_vin'

    @classmethod
    def get_scheme(cls):
        return None

    @classmethod
    def get_yt_list(cls):
        yt.config.set_proxy('hahn')

        table_path = yt.TablePath('//home/carsharing/production/car/cars_attr', columns=['vin'])
        column = yt.read_table(table_path)

        vin_list = []
        for row in column:
            vin_list.append(row['vin'])

        return vin_list

    @classmethod
    def parse_document(cls, input_file, output_file, meta=None):
        xl_file = openpyxl.open(input_file, data_only=True)
        sheet = xl_file.active

        column_number = None
        for row in sheet.iter_rows(0, 1):
            for col in range(0, sheet.max_column):
                key = sub(r"\s", '_', str.strip(str(row[col].value)).upper())
                if key == 'VIN':
                    column_number = col + 1
                continue

        if column_number is None:
            raise Exception('Column "VIN" not found')

        excel_vin = []
        for col in sheet.iter_cols(column_number, column_number):
            for row in range(1, sheet.max_row):
                if col[row].value is not None:
                    excel_vin.append(sub(r'\s+', ' ', str.strip(str(col[row].value))))

        yt_vin = cls.get_yt_list()

        ex_set_vin = set(excel_vin)
        yt_set_vin = set(yt_vin)

        diff = list(ex_set_vin.difference(yt_set_vin))

        data = {}
        rows = []
        if len(diff) > 0:
            for item in diff:
                rows.append({item: ''})

            data['VIN(s)'] = rows
            raise Exception(data)
