from argparse import ArgumentParser
from sys import stdout
from json import dumps, loads

# Register documents.
from .base import *
from .excel_validate import *
from .check_vin import *
from .check_decree import *
from .resolutions_on_payment import *


def formats_main(opts):
    formats = []
    for document in Document.get_documents():
        formats.append({
            "name": document.get_name(),
            "scheme": document.get_scheme(),
        })
    print(dumps({
        "formats": formats,
    }), file=stdout)


def parse_main(opts):
    doc_format = Document.get_document(opts.format)
    try:
        error = doc_format.parse_document(
            opts.input_file, opts.output_file, loads(opts.meta),
        )
    except Exception as exc:
        error = {
            "message": str(exc),
        }
    if error is not None:
        print(dumps(error), file=stdout)
        exit(1)
    exit(0)


def upload_main(opts):
    doc_format = Document.get_document(opts.format)
    try:
        error = doc_format.upload_document(opts.parsed_file)
    except Exception as exc:
        raise exc
        error = {
            "message": str(exc),
        }
    if error is not None:
        print(dumps(error), file=stdout)
        exit(1)
    exit(0)


def main():
    parser = ArgumentParser()
    subparsers = parser.add_subparsers()

    # formats command.
    formats = subparsers.add_parser("formats")
    formats.set_defaults(main=formats_main)

    # parse command.
    parse = subparsers.add_parser("parse")
    parse.set_defaults(main=parse_main)
    parse.add_argument("--format")
    parse.add_argument("--input-file")
    parse.add_argument("--output-file")
    parse.add_argument("--meta")

    # upload command.
    upload = subparsers.add_parser("upload")
    upload.set_defaults(main=upload_main)
    upload.add_argument("--format")
    upload.add_argument("--parsed-file")

    # Start command.
    opts = parser.parse_args()
    opts.main(opts)


if __name__ == "__main__":
    main()
