CREATE TABLE "adjust_event" ON CLUSTER '{cluster}' (
    "type" String,
    "created_at" Int64,
    "adjust_id" String,
    "idfa" String,
    "android_id" String,
    "app_id" String,
    "app_version" String,
    "installed_at" Nullable(Int64),
    "uninstalled_at" Nullable(Int64),
    "reinstalled_at" Nullable(Int64),
    "campaign_name" String,
    "adgroup_name" String,
    "creative_name" String,
    "label" String,
    "conversion_duration" Nullable(Int64),
    "click_time" Nullable(Int64),
    "country" String,
    "last_tracker_name" String,
    "connection_type" String,
    "device_name" String,
    "user_agent" String,
    "ip_address" String,
    "engagement_time" Int64,
    "impression_based" UInt8,
    "tracker_name" String,
    "user_id" String DEFAULT '',
    "utm_source" String DEFAULT '',
    "utm_medium" String DEFAULT '',
    "utm_campaign" String DEFAULT '',
    "utm_content" String DEFAULT '',
    "utm_term" String DEFAULT ''
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/marketing.adjust_event', '{replica}')
ORDER BY ("created_at", "type", "tracker_name", "adjust_id", "idfa", "android_id", "ip_address")
PARTITION BY toYYYYMM(toDateTime("created_at"));
