CREATE TABLE "riding_price_model_event" ON CLUSTER '{cluster}' (
    "time" Int64,
    "offer_id" String,
    "offer_type" String,
    "object_id" String,
    "price_model" String,
    "price_model_group" String,
    "riding_price" Float64,
    "before_price" Float64,
    "after_price" Float64
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/production.riding_price_model_event', '{replica}')
ORDER BY ("time", "offer_id", "price_model")
PARTITION BY toYYYYMM(toDateTime("time"))
TTL toDateTime("time") + INTERVAL 10 DAY;

CREATE TABLE "backend_log_event" ON CLUSTER '{cluster}' (
    "time" Int64,
    "event_type" Int8,
    "user_id" String,
    "object_id" String,
    "session_id" String,
    "total" Float64,
    "start_time" Int64,
    "duration" Int32,
    "riding_duration" Int32,
    "parking_duration" Int32,
    "origin" String,
    "path" String,
    "offer_type" String,
    "city" String
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/production.backend_log_event', '{replica}')
ORDER BY ("event_type", "time", "user_id", "object_id", "session_id")
PARTITION BY (toYYYYMMDD(toDateTime("time")), "event_type")
TTL toDateTime("time") + INTERVAL 10 DAY;
