CREATE TABLE "garage_field" (
    "id" serial not null constraint garage_field_pk primary key,
    "name" character varying(255) NOT NULL,
    "type" integer NOT NULL,
    "title" character varying(255) NOT NULL
);
CREATE UNIQUE INDEX "garage_field_name_idx" on "garage_field" ("name");

CREATE TABLE "garage_mutation" (
    "id" bigserial not null constraint garage_mutation_pk primary key,
    "user_id" character varying(255) NOT NULL,
    "comment" character varying(255) NOT NULL,
    "create_time" bigint NOT NULL
);

CREATE TABLE "garage_field_value" (
    "id" bigserial not null constraint garage_field_value_pk primary key,
    "field_id" integer NOT NULL,
    "vin" character varying(255) NOT NULL,
    "value" jsonb NOT NULL,
    "begin_time" bigint,
    "end_time" bigint,
    "create_id" bigint NOT NULL,
    "delete_id" bigint
);
CREATE INDEX "garage_field_create_idx" on "garage_field_value" ("create_id");
CREATE INDEX "garage_field_delete_idx" on "garage_field_value" ("delete_id");

CREATE VIEW "garage_field_value_view" AS
SELECT
    L."id" AS "id",
    L."vin" AS "vin",
    R."name" AS "field_name",
    L."value" AS "value",
    L."begin_time" AS "begin_time",
    L."end_time" AS "end_time",
    M."create_time" AS "create_time",
    M."comment" AS "create_comment",
    M."user_id" AS "create_user_id"
FROM "garage_field_value" AS L
JOIN "garage_field" AS R
ON L."field_id" = R."id"
JOIN "garage_mutation" AS M
ON L."create_id" = M."id"
WHERE L."delete_id" IS NULL;


CREATE TABLE "garage_document" (
    "id" bigserial NOT NULL CONSTRAINT garage_document_pk PRIMARY KEY,
    "user_id" character varying(255),
    "format" character varying(255) NOT NULL,
    "file_name" character varying(255) NOT NULL,
    "create_time" bigint NOT NULL
);
