CREATE TABLE "realtime_user_status_event" ON CLUSTER '{cluster}' (
    "time" Int64,
    "user_id" String,
    "from_status" String,
    "status" String
)
ENGINE = ReplicatedMergeTree('/clickhouse/tables/{shard}/production.realtime_user_status_event', '{replica}')
ORDER BY ("time", "status", "user_id")
PARTITION BY toYYYYMM(toDateTime("time"))
TTL toDateTime("time") + INTERVAL 60 DAY;
