# -*- coding: utf-8 -*-

from logging import getLogger
from drive.analytics.pybase.config import YT
from drive.analytics.pybase.models import session
from drive.library.py.thiefs import DelimobilV2
from drive.library.py.time import now
from .utils import solomon, get_animals_session, new_record


_log = getLogger(__name__)

_regions = {
    "msk": 1,
    "spb": 2,
    "nnv": 4,
    "ekb": 5,
    "nsb": 6,
    "sam": 7,
    "krd": 9,
    "rnd": 12,
    "tla": 13,
    "kzn": 14,
}


def _parse_region(args, region):
    labels = {"provider": "delimobil_v2", "action": "cars", "city": region}
    _log.info("Parsing Delimobil for region '{}'...".format(region))
    solomon.signal("begin", 1, labels)
    begin_time = now()
    http_client = get_animals_session(args)
    client = DelimobilV2(client=http_client)
    cars_resp = client.get_cars(_regions[region])
    models = {}
    for model in cars_resp["cars"]:
        models[model["id"]] = model
    cars = []
    for car_resp in cars_resp["geojson"]["features"]:
        car = {
            "id": car_resp["id"],
            "location": car_resp["geometry"]["coordinates"],  # [lon, lat].
            "model_name": car_resp["properties"]["model"],
        }
        cars.append(car)
    record = new_record(
        table="{}/data/thief/delimobil/raw_data".format(YT["home_path"]),
        name="cars/v2",
        result={"cars": cars},
        params={"city": region},
    )
    session.add(record)
    session.commit()
    solomon.signal("total_cars", len(cars), labels)
    duration = now() - begin_time
    _log.info("Parser finished.")
    solomon.signal("end", 1, labels)
    solomon.signal("duration", duration.total_seconds(), labels)


def main(args):
    for region in args.regions:
        try:
            _parse_region(args, region)
        except Exception as exc:
            _log.exception(exc)
    return 0
