# -*- coding: utf-8 -*-

from argparse import ArgumentParser
from .utils import setup_solomon


def belkacar_main(args):
    from .belkacar import main
    main(args)


def delimobil_main(args):
    from .delimobil import main
    main(args)


def transport_main(args):
    from .transport import main
    main(args)


def youdrive_main(args):
    from .youdrive import main
    main(args)


def main():
    setup_solomon()
    parser = ArgumentParser()
    subparsers = parser.add_subparsers(dest="command", required=True)
    transport_cmd = subparsers.add_parser("transport")
    transport_cmd.add_argument("--disable-animals", action="store_true")
    transport_cmd.add_argument("--load-cars-info", action="store_true")
    transport_cmd.set_defaults(main=transport_main)
    belkacar_cmd = subparsers.add_parser("belkacar")
    belkacar_cmd.add_argument("--disable-animals", action="store_true")
    belkacar_cmd.set_defaults(main=belkacar_main)
    delimobil_cmd = subparsers.add_parser("delimobil")
    delimobil_cmd.add_argument("--disable-animals", action="store_true")
    delimobil_cmd.add_argument("--regions", nargs="+")
    delimobil_cmd.set_defaults(main=delimobil_main)
    youdrive_cmd = subparsers.add_parser("youdrive")
    youdrive_cmd.add_argument("--disable-animals", action="store_true")
    youdrive_cmd.set_defaults(main=youdrive_main)
    args = parser.parse_args()
    raise SystemExit(args.main(args))
