# -*- coding: utf-8 -*-

from requests import Session
from random import choice
from drive.analytics.pybase.models import session
from drive.analytics.pybase.models.thief import YtRows, Account
from drive.analytics.pybase.helpers import get_animals, get_solomon
from drive.library.py.time import now, to_timestamp


solomon = None


def setup_solomon():
    global solomon
    solomon = get_solomon("thief")


def get_animals_session(args):
    if args.disable_animals:
        return Session()
    return get_animals()


def _get_accounts_query(provider, status=Account.STATUS_ALIVE):
    return (
        session.query(Account).
            filter(Account.provider == provider).
            filter(Account.status == status)
    )


def get_random_account(provider, city, status=Account.STATUS_ALIVE):
    query = _get_accounts_query(provider, status)
    accounts = []
    for account in query:
        if city in account.data["cities"]:
            accounts.append(account)
    if not accounts:
        raise RuntimeError(
            "Unable to found account for city '{}'".format(city)
        )
    return choice(accounts)


def new_record(table, name, result, params=None, status="success"):
    date = now()
    row = dict(
        timestamp=int(to_timestamp(date)),
        name=name,
        params=params or dict(),
        status=status,
        result=result,
    )
    return YtRows(
        timestamp=date.replace(tzinfo=None),
        path=table,
        rows=(row,)
    )
