# -*- coding: utf-8 -*-

from logging import getLogger
from drive.analytics.pybase.config import YT
from drive.analytics.pybase.models import session
from drive.library.py.thiefs import YoudriveClient
from drive.library.py.time import now
from .utils import solomon, get_animals_session, new_record, get_random_account


_log = getLogger(__name__)


def _load_city_cars(args, city):
    labels = {"provider": "youdrive", "action": "cars", "city": city}
    _log.info("Parsing Youdrive for city '{}'...".format(city))
    solomon.signal("begin", 1, labels)
    begin_time = now()
    http_client = get_animals_session(args)
    client = YoudriveClient(client=http_client)
    account = get_random_account("youdrive", city)
    token = account.data["token"]
    location = (
        account.data["home_location"]["longitude"],
        account.data["home_location"]["latitude"],
    )
    cars = client.status(token, location)
    record = new_record(
        table="{}/data/thief/youdrive/raw_data".format(YT["home_path"]),
        name="cars/v2",
        result=cars,
        params={"city": city},
    )
    session.add(record)
    session.commit()
    solomon.signal("total_cars", len(cars["cars"]), labels)
    duration = now() - begin_time
    _log.info("Parser finished.")
    solomon.signal("end", 1, labels)
    solomon.signal("duration", duration.total_seconds(), labels)


def main(args):
    for city in ("global",):
        try:
            _load_city_cars(args, city)
        except Exception as exc:
            _log.exception(exc)
    return 0
