package models

import (
	"github.com/gofrs/uuid"

	fp "a.yandex-team.ru/drive/backend/proto"
)

// CompiledBill represents compiled bill.
type CompiledBill struct {
	baseEvent
	SessionID   string    `json:"session_id" db:"session_id" yson:"session_id"`
	UserID      uuid.UUID `json:"user_id" db:"user_id" yson:"user_id"`
	Bill        int       `json:"bill" db:"bill" yson:"bill"`
	BillingType string    `json:"billing_type" db:"billing_type" yson:"billing_type"`
	Details     NString   `json:"details" db:"details" yson:"details"`
}

// ParseDetails returns parsed bill details.
func (b CompiledBill) ParseDetails() (*fp.TCompiledBillMeta, error) {
	var meta fp.TCompiledBillMeta
	if err := parseProtoBase64(string(b.Details), &meta); err != nil {
		return nil, err
	}
	return &meta, nil
}
