package models

import (
	"github.com/gofrs/uuid"

	"a.yandex-team.ru/zootopia/library/go/db/objects"
)

// User represents user data.
type User struct {
	// ID contains user ID.
	ID uuid.UUID `db:"id"`
	// UID contains passport UID.
	UID NInt64 `db:"uid"`
	// Username contains yandex login.
	Username string `db:"username"`
	// Email contains email.
	Email NString `db:"email"`
	// Phone contains phone number.
	Phone NString `db:"phone"`
	// Status contains status.
	Status NString `db:"status"`
	// RegisterTime contains register time.
	RegisterTime NTime `db:"registered_at"`
	// RegisterGeo contains registration geo.
	RegisterGeo NString `db:"registration_geo"`
	// LicenseRevision.
	LicenseRevision NString `db:"driving_license_ds_revision"`
	// PassportRevision.
	PassportRevision NString `db:"passport_ds_revision"`
}

// ObjectID returns ID of user.
func (o User) ObjectID() objects.ID {
	return o.ID
}

type UserEvent struct {
	baseEvent
	User
}
