package config

import (
	"a.yandex-team.ru/drive/analytics/gobase/models"
	"a.yandex-team.ru/drive/library/go/gosql"
	"a.yandex-team.ru/drive/library/go/secret"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/zootopia/analytics/drive/config"
)

// Config contains all Drive configurations.
type Config struct {
	config.Config
	// LogLevel contains log level.
	LogLevel log.Level `json:"log_level"`
	// DBs contains all connections to databases.
	DBs map[string]gosql.Config `json:"dbs"`
	// TVMs contains all tvm clients.
	TVMs map[string]TVM `json:"tvms"`
	// YTs contains all YT clients.
	YTs map[string]YT `json:"yts"`
	// Drives contains all Drive clients.
	Drives map[string]Drive `json:"drives"`
	// CoreDB contains name of DB connection for core.
	CoreDB string `json:"core_db"`
	// BackendDB contains name of backend DB connection.
	BackendDB string `json:"backend_db"`
	// Solomon contains solomon configuration.
	Solomon *Solomon `json:"solomon"`
	// BB contains blackbox configuration.
	BB *BB `json:"bb"`
	// Adjust contains Adjust configuration.
	Adjust *Adjust `json:"adjust"`
	// Drive contains drive client configuration.
	Drive *Drive `json:"drive"`
	// YT contains YT configuration.
	YT *YT `json:"yt"`
	// YTPaths contains yt paths configuration.
	YTPaths *config.YTPaths `json:"yt_paths"`
	// RenisKBM contains configuration for Renissanse KBM API.
	RenisKBM *RenisKBM `json:"renis_kbm"`
	// Fuelings contains configuration for fuelings.
	Fuelings *Fuelings `json:"fuelings"`
	// Tracks contains configuration for tracks.
	Tracks *Tracks `json:"tracks"`
	// Animals contains configuration for animals
	Animals *Animals `json:"animals"`
}

// Adjust represents Adjust configuration.
type Adjust struct {
	// DB contains name of adjust DB connection.
	DB string `json:"db"`
	// Table contains name of adjust table.
	Table string `json:"table"`
	// Secret contains secret token.
	Secret secret.Secret `json:"secret"`
}

// YT contains YT configuration.
type YT struct {
	// Proxy contains name of proxy.
	Proxy string `json:"proxy"`
	// Token contains auth token.
	Token secret.Secret `json:"token"`
}

// Drive contains Drive API configuration.
type Drive struct {
	// Endpoint contains endpoint.
	Endpoint string `json:"endpoint"`
	// Token contains auth token.
	Token secret.Secret `json:"token"`
	// Query contains query.
	Query map[string]string `json:"query"`
}

// TVM contains TVM client configuration.
type TVM struct {
	// Source contains source.
	Source tvm.ClientID `json:"source"`
	// Secret contains secret.
	Secret secret.Secret `json:"secret"`
	// Targets contains targets.
	Targets map[string]tvm.ClientID `json:"targets"`
}

// Solomon represents Solomon configuration.
type Solomon struct {
	Endpoint string `json:"endpoint"`
	Project  string `json:"project"`
	Cluster  string `json:"cluster"`
	Service  string `json:"service"`
	// Source represents name of TVM source.
	Source string `json:"source"`
	// Target represents name of TVM target.
	Target string `json:"target"`
}

// BB represents bb configuration.
type BB struct {
	Source string `json:"source"`
	Env    string `json:"env"`
}

// RenisKBM represents Renis KBM service configuration.
type RenisKBM struct {
	Endpoint   string        `json:"endpoint"`
	ClientName secret.Secret `json:"client_name"`
	PartnerUID secret.Secret `json:"partner_uid"`
}

// Fuelings represents configuration for fuelings processes.
type Fuelings struct {
	Providers       map[string]FuelingProvider `json:"providers"`
	ReportsTable    ypath.Path                 `json:"reports_table"`
	OperationsTable ypath.Path                 `json:"operations_table"`
}

type FuelingProvider struct {
	Provider string      `json:"provider"`
	Config   models.JSON `json:"config"`
}

type Tracks struct {
	BinaryPath        string `json:"binary_path"`
	YDBEndpoint       string `json:"ydb_endpoint"`
	YDBDatabase       string `json:"ydb_database"`
	YDBTable          string `json:"ydb_table"`
	MatcherConfigPath string `json:"matcher_config_path"`
	FilterConfigPath  string `json:"filter_config_path"`
	TracksTable       string `json:"tracks_table"`
}

type Animals struct {
	URL      string `json:"url"`
	User     string `json:"user"`
	Password string `json:"password"`
}
